<?php
/*
 * $Id: export_invoices.php,v 1.1 2007/09/23 20:04:33 jm Exp $
 * 
 * Created on 16 mars 07 by AEL Sarl for
 * 
 * osCommerce, Open Source E-Commerce Solutions
 * http://www.oscommerce.com
 *
 * Copyright (c) 2003 osCommerce
 *
 * Released under the GNU General Public License
 * 
 */
 
  require('includes/application_top.php');
  require(DIR_WS_CLASSES . 'export_invoices_counters.php');
  
  function get_month($entry_date) {
   return substr(tep_date_raw($entry_date), 4, 2);
  }
 
  function get_day($entry_date) {
 	 return substr(tep_date_raw($entry_date), 6, 2);
  }
 
  function get_year($entry_date) {
 	 return substr(tep_date_raw($entry_date), 0, 4);
  }
 
  function export_checkdate($entry_date) {
 	 return checkdate(substr(tep_date_raw($entry_date), 4, 2), substr(tep_date_raw($entry_date), 6, 2), substr(tep_date_raw($entry_date), 0, 4));
  }
  
  function is_lower($date1, $date2) {
  	return (mktime(0, 0, 0, get_month($date1), get_day($date1), get_year($date1)) - 
  	        mktime(0, 0, 0, get_month($date2), get_day($date2), get_year($date2)) < 0);
  }
  
  $lines = false;
  $counter = new eiCounters('EXPORT_BEGIN');
  
  if (isset($_POST['processed'])) {
  	if (isset($_POST['export_begin']))
   		$export_begin = $_POST['export_begin'];	
 		if (isset($_POST['export_end']))
   		$export_end = $_POST['export_end'];
   
    $error = 0;
	  if (!export_checkdate($export_begin )) {
	 	  $messageStack->add(ENTRY_EXPORT_BEGIN_ERROR);
	 	  $error = 1;
	  }
	  if (!export_checkdate($export_end )) {
	 	  $messageStack->add(ENTRY_EXPORT_END_ERROR);
	 	  $error = 1;
	  }
    if (is_lower($export_end, $export_begin)) {
      $messageStack->add(ENTRY_EXPORT_BOUNDARIES_ERROR);
 	    $error = 1;
    }
    
    if ($error == 0) {
    	$export_query =  tep_db_query(
												"SELECT o.orders_id, ac.account_number, ac.account_name, op.products_tax, " .
												"op.products_quantity, op.final_price, " .
	   										"ot.value as total_included_tax, o.currency, invoice_number, invoice_date " .
												"FROM " . TABLE_ORDERS . " o, " . TABLE_ORDERS_TOTAL . " ot, " . TABLE_ORDERS_PRODUCTS . " op, " .
												TABLE_PRODUCTS . " p, " . TABLE_ACCOUNTS_CHART . " ac, " . TABLE_INVOICE . " i" . 
	                      " WHERE i.invoice_date BETWEEN '" . tep_date_raw($export_begin) . "' AND '" .
	                      tep_date_raw($export_end) . "' AND o.invoice_id=i.invoice_id " .
                        "AND op.products_id=p.products_id " .
                        "AND o.orders_id=op.orders_id " .
	                      "AND p.account_number=ac.account_number " .
	                      "AND ot.orders_id=o.orders_id " .
	                      "AND ot.class='ot_total' " .
	                      "ORDER BY invoice_number");
			
			$separator_query = tep_db_query("select field_separator_value from " . TABLE_FIELD_SEPARATOR . 
					                            " where field_separator_id=" .INVOICE_FIELD_SEPARATOR);
			$separators = tep_db_fetch_array($separator_query);
			$sep = $separators['field_separator_value'];
			
			/* update the counter, or insert a new row */
			$counter->insert(tep_date_raw_delimited($export_end));
			
			/* get the module */
			$module_name = EXPORT_INVOICES_MODULE;
			include(DIR_WS_MODULES . 'export_invoices/' . $module_name . ".php");
    	$module = new $module_name($sep);
			if (tep_db_num_rows($export_query) > 0) {
				$lines = true;
				echo $module->export($export_query);
				exit;
			}
    }
  } else {
	  $export_begin = $counter->counters_value ? tep_date_short($counter->counters_value) : '';
	  
	  $date_help_text = '<span style="font-family: Verdana, Arial, sans-serif; font-size: 10px; color: #ff0000;">' . DATE_FORMAT_HELP_TEXT . '</span>';
  }

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html <?php echo HTML_PARAMS; ?>>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=<?php echo CHARSET; ?>">
<title><?php echo TITLE; ?></title>
<link rel="stylesheet" type="text/css" href="includes/stylesheet.css">
<script type="text/javascript">
var saved_export_begin = null;

function DateExport(export_date) {
    this.year = null;
    this.month = null;
    this.day = null;
    this.isEuro = false;
    this.isIso = false;

    var date_array;
    if (date_array = /^(\d{2})[\/|-]{1}(\d{2})[\/|-]{1}(\d{4})$/.exec(export_date)) {
        this.isEuro = true;
        this.year = date_array[3];
        this.month = date_array[2];
        this.day = date_array[1];
    } else if (date_array = /(\d{4})[\|/-]{1}(\d{2})[\|/-]{1}(\d{2})/.exec(export_date)) {
        this.isIso = true;
        this.year = date_array[1];
        this.month = date_array[2];
        this.day = date_array[3];
    }
}

DateExport.prototype.toDate = function() {
    return new Date(this.year, this.month - 1, this.day, 0, 0, 0);
}

DateExport.prototype.compare = function(another_export_date) {
    var thisDate = this.toDate();
    var anotherDate = another_export_date.toDate();
    if (thisDate > anotherDate)
        return 1;
    else {
        if (anotherDate.getYear() == thisDate.getYear() &&
            anotherDate.getMonth() == thisDate.getMonth() &&
            anotherDate.getDay() == thisDate.getDay())
            return 0;
        return -1;
    }
}

DateExport.prototype.asString = function() {
    var format;
    if (this.isEuro)
        format = "Euro";
    else if (this.isIso)
        format = "Iso";
    else
        format = "Format inconnu !";
    return format + " : " + this.day + "-" + this.month + "-" + this.year;
}

function check_form() {
    var errmsg = "";
    var warnmsg = "";
    var export_begin = document.export_invoices.export_begin.value;
    var export_end = document.export_invoices.export_end.value;
    var date_export_begin = new DateExport(export_begin);
    var date_export_end = new DateExport(export_end);

    if (!date_export_begin.isIso && !date_export_begin.isEuro)
        errmsg += "\n" + "<?php echo JS_EXPORT_BEGIN_ERROR . '\n(' . JS_EXPORT_INVOICES_DATE_ERROR . ')';?>";
    if (!date_export_end.isIso && !date_export_end.isEuro)
        errmsg += "\n" + "<?php echo JS_EXPORT_END_ERROR . '\n(' . JS_EXPORT_INVOICES_DATE_ERROR . ')';?>";
    if (date_export_begin.compare(date_export_end) != - 1)
        errmsg += "\n" + "<?php echo JS_EXPORT_INVOICES_INTERVAL_ERROR; ?>";
    if (saved_export_begin && date_export_begin.compare(new DateExport(saved_export_begin)) == -1)
        warnmsg = "<?php echo JS_EXPORT_INVOICES_PREVIOUS_EXPORT;?>";
    if (errmsg) {
        alert(errmsg);
        return false;
    }
    if (warnmsg)
        alert(warnmsg);
    return true;
}

function save_export_begin() {
    var export_begin = document.export_invoices.export_begin.value;
    if (export_begin != "")
        saved_export_begin = export_begin;
}
</script>
</head>
<body bgcolor="#FFFFFF" onload="save_export_begin();">
<!-- header //-->
<?php require(DIR_WS_INCLUDES . 'header.php'); ?>
<!-- header_eof //-->

<!-- body //-->
<table border="0" width="100%" cellspacing="2" cellpadding="2">
  <tr>
    <td width="<?php echo BOX_WIDTH; ?>" valign="top"><table border="0" width="<?php echo BOX_WIDTH; ?>" cellspacing="1" cellpadding="1" class="columnLeft">
<!-- left_navigation //-->
<?php require(DIR_WS_INCLUDES . 'column_left.php'); ?>
<!-- left_navigation_eof //-->
    </table></td>
<!-- body_text //-->
    <td width="100%" valign="top"><table border="0" width="100%" cellspacing="0" cellpadding="2">
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td class="pageHeading"><?php echo HEADING_TITLE; ?></td>
            <td class="pageHeading" align="right"><?php echo tep_draw_separator('pixel_trans.gif', HEADING_IMAGE_WIDTH, HEADING_IMAGE_HEIGHT); ?></td>
          </tr>
        </table></td>
      </tr>
<?php
  if ($messageStack->size > 0) {
?>
      <tr>
        <td><?php echo $messageStack->output(); ?></td>  
      </tr>
<?php
  }
?>
      <tr>
        <td><?php echo tep_draw_separator('pixel_trans.gif', '100%', '10'); ?></td>
      </tr>
      <tr>
        <td><table border="0" width="100%" cellspacing="0" cellpadding="0">
          <tr>
            <td valign="top">
              <?php echo tep_draw_form('export_invoices', FILENAME_EXPORT_INVOICES, $parameters='', $method="post", $params='onSubmit="return check_form();"'); ?><table border="0" width="100%" cellspacing="0" cellpadding="2">
              <tr class="dataTableHeadingRow">
                <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_EXPORT_BEGIN; ?></td>
                <td class="dataTableHeadingContent"><?php echo TABLE_HEADING_EXPORT_END; ?></td>
                <td class="dataTableHeadingContent" align="right"><?php echo TABLE_HEADING_ACTION; ?></td>
              </tr>
              <tr bgcolor="#ebebff">
            		<td class="main"><?php echo tep_draw_separator('pixel_trans.gif', '24', '15') . '&nbsp;' . tep_draw_input_field('export_begin', $value=$export_begin, $parameters='size="8" maxlength="10"') . '&nbsp;'. $date_help_text; ?></td>
            		<td class="main"><?php echo tep_draw_separator('pixel_trans.gif', '24', '15') . '&nbsp;' . tep_draw_input_field('export_end', $value='', $parameters='size="8" maxlength="10"') . '&nbsp;' . $date_help_text; ?></td>
            		<td class="main" align="right"><?php echo tep_image_submit('button_export.gif', IMAGE_EXPORT) . ' <a href="' . tep_href_link(FILENAME_EXPORT_INVOICES) . '"></a>'; ?></td>
          		</tr>
            </table><?php echo tep_draw_hidden_field('processed', $value='0'); ?></form></td>
          </tr>
<?php
  if (isset($_POST['processed']) && !$lines) {
  	echo '<tr bgcolor="#ebebff"><td>';
  	echo tep_image(DIR_WS_ICONS . 'warning.gif', ICON_WARNING) . '&nbsp;' . EXPORT_NO_INVOICE;
  	echo '</tr>';
  }
?>
        </table></td>
      </tr>
    </table></td>
<!-- body_text_eof //-->
  </tr>
</table>
<!-- body_eof //-->

<!-- footer //-->
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>
<!-- footer_eof //-->
<br>
</body>
</html>
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>
