<?php
/*
 * $Id: opensi.php,v 1.1 2007/09/23 20:04:34 jm Exp $
 * 
 * Created on 15 mai 07 by AEL Sarl for
 * 
 * osCommerce, Open Source E-Commerce Solutions
 * http://www.oscommerce.com
 *
 * Copyright (c) 2003 osCommerce
 *
 * Released under the GNU General Public License
 * 
 */

require('standard.php');

class opensi extends standard {

	var $export;
	
	function opensi() {
		parent::standard();
		$this->content_type = "text/xml";
		$this->key = 'opensi';
		$this->description = 'Module OpenSI';
	}
	
	function _write_accounts_chart() {
		$comptes = array();
		foreach ($this->accounts as $account_number => $account_values) {
			$compte = $this->export->createElement('compte');
			$compte->setAttribute('numero', $account_number);
			$compte->setAttribute('intitule', $account_values['name']);
			if ($account_values['type'] == 'CUS')
				$compte->setAttribute('type', "C");
			else
				$compte->setAttribute('type', "G");
			$comptes[] = $compte;
		}
		
		return $comptes;
	}
	
	function _write_account($row, $handler) {
		$lines = array();
		$current_handler = $handler;
		$row['operation_mode'] = 'credit';
		while ($current_handler != null) {
			if ($current_handler->value != 0) {
				$row['account_name'] = $current_handler->account_name;
				$row['account_number'] = $current_handler->account_number;
				$row['products_excluded_tax'] = $current_handler->value;
				$lines[] = $this->_write_line($row);
			}
			$current_handler = $current_handler->next_handler;
		}
		
		return $lines;
	}
	
	function _write_tax_account($row) {
		$lines = array();
		$handler = $this->tax_manager;
		$row['operation_mode'] = 'credit';
		while ($handler != null) {
			if ($handler->value != 0) {
				$row['account_name'] = $handler->account_name;
				$row['account_number'] = $handler->account_number;
				$row['products_excluded_tax'] = $handler->value;
				$lines[] = $this->_write_line($row);
			}
			$handler = $handler->next_handler;
		}
		
		return $lines;
	}
	
	function _write_customer_account($row) {
		$row['operation_mode'] = 'debit';
		$row['account_name'] = $this->customer_account['name'];
		$row['account_number'] = $this->customer_account['number'];
		$row['products_excluded_tax'] = $row['total_included_tax'];
		$lines[] = $this->_write_line($row);
		
		return $lines;
	}
	
	function _write_shipping_account($row) {
		$lines = array();
		// write the shipping operation
		$row['operation_mode'] = 'credit';
		$row['account_name'] = $this->shipping_account['name'];
		$row['account_number'] = $this->shipping_account['number'];
		$lines[] = $this->_write_line($row);
		
		return $lines;
	}
	
	function _write_line($row) {
		$op = $this->export->createElement($row['operation_mode']);
		$op->setAttribute('date', $row['invoice_date']);
		$op->setAttribute('libelle', $row['account_name']);
		$op->setAttribute('compte', $row['account_number']);
		$op->setAttribute('montant', tep_round($row['products_excluded_tax'], 2) * 100);
		$op->setAttribute('numpiece', $row['invoice_number']);
		$op->setAttribute('echeance', '');
		$op->setAttribute('lettre', '');
		
		return $op;
		
	}
	
	function _merge($parent, $childs) {
		foreach ($childs as $child)
			$child = $parent->appendChild($child);
		// returns the last created child
		return $child;
	}
	
	function _export($row) {
		static $previous_row = null;
		$root = $this->export->getElementsByTagName('compta_opensi')->item(0);
		
		// manage the shipping part at end of order process
		// ie when a new order needs to be processed
		// or when there is no more order (last order is a null row)
		if ($row == null ||
		    ($row != null && $previous_row != null && $row['orders_id'] != $previous_row['orders_id'])) {
		 	$this->_manage_shipping($previous_row['orders_id']);
		 	
		 	$ecriture = $this->export->createElement('ecriture');
			$ecriture->setAttribute('periode', substr($previous_row['invoice_date'], 2));
			$ecriture->setAttribute('journal', SALES_JOURNAL);
			
			// write the excluded tax amount ordered by account number
		 	$operation = $this->_merge($ecriture, $this->_write_account($previous_row, $this->sale_manager));
		 	// write all taxes values
		 	$operation = $this->_merge($ecriture, $this->_write_account($previous_row, $this->tax_manager));
		 	// write the customer part, included tax, at the end
		 	$operation = $this->_merge($ecriture, $this->_write_customer_account($previous_row));
		 	
		 	$ecriture = $this->_merge($root, array($ecriture));
		 	$this->tax_manager->clear();
		 	$this->sale_manager->clear();
		}
		
		if ($row != null) {
			$this->_handle_current_row($row);
			// store the old row
			$previous_row = $row;
		}
		
		return $root;
	}
	
	function export($query) {
		/**
		 * Export the formatted lines of data
		 * 
		 * @param query     a SQL Result of fetched informations
		 */
	
		header('Content-type: ' . $this->content_type);
    header('Content-disposition: attachment; filename=' . EXPORT_INVOICES_FILENAME);
    $this->export = new DOMDocument('1.0');
    $this->export->encoding = "utf-8";
    $root = $this->export->createElement('compta_opensi');
    $root = $this->export->appendChild($root);
    
    $this->_merge($root, $this->_write_accounts_chart());
    
    while ($row = tep_db_fetch_array($query))
    	$root = $this->_export($row);
    	
    // now manage the last order
    $root = $this->_export(null);
    
    $this->export->formatOutput = true;
    return $this->export->saveXML();
	}
	
} 
?>
