<?php
/*
  $Id: ot_cod_bymg.php,v 1.01 2006/01/10 20:17:00 dgw_ Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  Publikowane na zasadach licencji GNU General Public License

  Autor:  Marcin Gbu <oscommerce-help@gebus.pl>
  http://www.abcgarbus.gebus.pl
*/

  class ot_codbymg {
    var $title, $output;

    function ot_codbymg() {
      $this->code = 'ot_codbymg';
      $this->title = MODULE_ORDER_TOTAL_CODBYMG_TITLE;
      $this->description = MODULE_ORDER_TOTAL_CODBYMG_DESCRIPTION;
      $this->enabled = ((MODULE_ORDER_TOTAL_CODBYMG_STATUS == 'true') ? true : false);
      $this->sort_order = MODULE_ORDER_TOTAL_CODBYMG_SORT_ORDER;

      $this->output = array();
    }

    function process() {
      global $order, $currencies;

      if (tep_not_null($order->info['cod_method'])) {

        $this->output[] = array('title' => $order->info['cod_method'] . ':',
                                'text'  => $currencies->format($order->info['cod_cost'], true, $order->info['currency'], $order->info['currency_value']),
                                'value' => $order->info['cod_cost']);
      }
    }

    function check() {
      if (!isset($this->_check)) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_CODBYMG_STATUS'");
        $this->_check = tep_db_num_rows($check_query);
      }

      return $this->_check;
    }

    function keys() {
      return array('MODULE_ORDER_TOTAL_CODBYMG_STATUS', 'MODULE_ORDER_TOTAL_CODBYMG_SORT_ORDER', 'MODULE_ORDER_TOTAL_CODBYMG_PAYMENT_TYPE');
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Display Cod',             'MODULE_ORDER_TOTAL_CODBYMG_STATUS',       'true',    'Do you want to display COD cost?', '6', '1','tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order,               date_added) values ('Sort Order',              'MODULE_ORDER_TOTAL_CODBYMG_SORT_ORDER',   '3',       'Sort order of display.',           '6', '3',                                                      now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order,               date_added) values ('Enable for COD payments', 'MODULE_ORDER_TOTAL_CODBYMG_PAYMENT_TYPE', 'codbymg', 'List of payments metod',           '6', '7',                                                      now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
  }
?>
