<?php
/*
  Original file by:
  
  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  
  This file is modified by Madis Peterson for Estonian language pack.
*/

// look in your $PATH_LOCALE/locale directory for available locales
// or type locale -a on the server.
// Examples:
// on RedHat try 'en_US'
// on FreeBSD try 'en_US.ISO_8859-1'
// on Windows try 'en', or 'English'
@setlocale(LC_TIME, 'et_EE.ISO_8859-1');

define('DATE_FORMAT_SHORT', '%d/%m/%Y');  // this is used for strftime()
define('DATE_FORMAT_LONG', '%A %d %B, %Y'); // this is used for strftime()
define('DATE_FORMAT', 'd/m/Y'); // this is used for date()
define('DATE_TIME_FORMAT', DATE_FORMAT_SHORT . ' %H:%M:%S');

////
// Return date in raw format
// $date should be in format mm/dd/yyyy
// raw date is in format YYYYMMDD, or DDMMYYYY
function tep_date_raw($date, $reverse = false) {
  if ($reverse) {
    return substr($date, 3, 2) . substr($date, 0, 2) . substr($date, 6, 4);
  } else {
    return substr($date, 6, 4) . substr($date, 0, 2) . substr($date, 3, 2);
  }
}

// if USE_DEFAULT_LANGUAGE_CURRENCY is true, use the following currency, instead of the applications default currency (used when changing language)
define('LANGUAGE_CURRENCY', 'EEK');

// Global entries for the <html> tag
define('HTML_PARAMS','dir="LTR" lang="et');

// charset for web pages and emails
define('CHARSET', 'iso-8859-1');

// page title
define('TITLE', 'e-medicalonline.com');

// header text in includes/header.php
define('HEADER_TITLE_CREATE_ACCOUNT', 'Ava kasutajakonto');
define('HEADER_TITLE_MY_ACCOUNT', 'Minu konto');
define('HEADER_TITLE_CART_CONTENTS', 'Ostukorvi sisu');
define('HEADER_TITLE_CHECKOUT', 'Minu tellimused');
define('HEADER_TITLE_TOP', 'On-line kauplus');
define('HEADER_TITLE_CATALOG', 'Avaleht');
define('HEADER_TITLE_LOGOFF', 'Login vlja');
define('HEADER_TITLE_LOGIN', 'Login sisse');

// footer text in includes/footer.php
define('FOOTER_TEXT_REQUESTS_SINCE', 'vaatamist alates:');

// text for gender
define('MALE', 'Mees');
define('FEMALE', 'Naine');
define('MALE_ADDRESS', 'Mr.');
define('FEMALE_ADDRESS', 'Pr.');

// text for date of birth example
define('DOB_FORMAT_STRING', 'mm/dd/yyyy');

// categories box text in includes/boxes/categories.php
define('BOX_HEADING_CATEGORIES', 'Kaubagrupid');

// manufacturers box text in includes/boxes/manufacturers.php
define('BOX_HEADING_MANUFACTURERS', 'Tootjad');

// whats_new box text in includes/boxes/whats_new.php
define('BOX_HEADING_WHATS_NEW', 'Uudised');

// quick_find box text in includes/boxes/quick_find.php
define('BOX_HEADING_SEARCH', 'Otsing');
define('BOX_SEARCH_TEXT', '<b>Nimetuse jrgi</b><br>(sisestage otsingusna ja vajutage luubile)<br>');
define('BOX_SEARCH_ADVANCED_SEARCH', 'Laiendatud otsing');

// specials box text in includes/boxes/specials.php
define('BOX_HEADING_SPECIALS', 'Eripakkumised');

// reviews box text in includes/boxes/reviews.php
define('BOX_HEADING_REVIEWS', 'Arvamused');
define('BOX_REVIEWS_WRITE_REVIEW', 'Lisan oma arvamuse selle kauba kohta!');
define('BOX_REVIEWS_NO_REVIEWS', 'Praegu arvamused puuduvad');
define('BOX_REVIEWS_TEXT_OF_5_STARS', '%s vimalikust 5-st trnist!');

// shopping_cart box text in includes/boxes/shopping_cart.php
define('BOX_HEADING_SHOPPING_CART', 'Ostukorvi sisu');
define('BOX_SHOPPING_CART_EMPTY', '0 kaupa');

// order_history box text in includes/boxes/order_history.php
define('BOX_HEADING_CUSTOMER_ORDERS', 'Minu tellimused');

// best_sellers box text in includes/boxes/best_sellers.php
define('BOX_HEADING_BESTSELLERS', 'Enimmdud');
define('BOX_HEADING_BESTSELLERS_IN', 'Enimmdud<br>');

// notifications box text in includes/boxes/products_notifications.php
define('BOX_HEADING_NOTIFICATIONS', 'Teavitused');
define('BOX_NOTIFICATIONS_NOTIFY', 'Soovin uudiseid antud toote kohta: <b>%s</b>');
define('BOX_NOTIFICATIONS_NOTIFY_REMOVE', 'Ei soovi uudiseid antud toote kohta: <b>%s</b>');

// manufacturer box text
define('BOX_HEADING_MANUFACTURER_INFO', 'Tootjainfo');
define('BOX_MANUFACTURER_INFO_HOMEPAGE', 'Tootja koduleht');
define('BOX_MANUFACTURER_INFO_OTHER_PRODUCTS', 'Muud tooted');

// languages box text in includes/boxes/languages.php
define('BOX_HEADING_LANGUAGES', 'Keeled');

// currencies box text in includes/boxes/currencies.php
define('BOX_HEADING_CURRENCIES', 'Valuuta');

// information box text in includes/boxes/lingid.php
define('BOX_HEADING_INTERNETIPANK', 'Internetipank');

// information box text in includes/boxes/information.php
define('BOX_HEADING_INFORMATION', 'Informatsioon');
define('BOX_INFORMATION_PRIVACY', 'Kontaktandmed');
define('BOX_INFORMATION_CONDITIONS', 'Kuidas tellida');
define('BOX_INFORMATION_SHIPPING', 'Kohaletoimetamine');
define('BOX_INFORMATION_CONTACT', 'Tagasiside');

// tell a friend box text in includes/boxes/tell_a_friend.php
define('BOX_HEADING_TELL_A_FRIEND', 'Soovitan sbrale');
define('BOX_TELL_A_FRIEND_TEXT', 'Teavita teda antud tootest');

// checkout procedure text
define('CHECKOUT_BAR_DELIVERY', 'Kttetoimetamine');
define('CHECKOUT_BAR_PAYMENT', 'Maksmine');
define('CHECKOUT_BAR_CONFIRMATION', 'Kinnitus');
define('CHECKOUT_BAR_FINISHED', 'Kinnitatud!');

// pull down default text
define('PULL_DOWN_DEFAULT', 'Palun valige');
define('TYPE_BELOW', 'Titke lahter');

// javascript messages
define('JS_ERROR', 'Andmete sisestamisel on tekkinud viga.\n\nPalun tehke jrgmised parandused:\n\n');

define('JS_REVIEW_TEXT', '* \'Teie arvustus\' pikkus peab minimaalselt olema ' . REVIEW_TEXT_MIN_LENGTH . ' themrki.\n');
define('JS_REVIEW_RATING', '* Palun andke tootele hinnang numbriskaalal.\n');

define('JS_ERROR_NO_PAYMENT_MODULE_SELECTED', '* Palun valige makseviis.\n');

define('JS_ERROR_SUBMITTED', 'Te juba kinnitasite antud andmed. Palun vajutage Ok ja oodake, kuni toiming on lpetatud.');

define('ERROR_NO_PAYMENT_MODULE_SELECTED', 'Palun valige makseviis.');

define('CATEGORY_COMPANY', 'Ettevtte andmed');
define('CATEGORY_PERSONAL', 'Teie iskuandmed');
define('CATEGORY_ADDRESS', 'Teie aadress');
define('CATEGORY_CONTACT', 'Kontaktandmed');
define('CATEGORY_OPTIONS', 'Valikud');
define('CATEGORY_PASSWORD', 'Teie salasna');

define('ENTRY_COMPANY', 'Ettevtte nimetus:');
define('ENTRY_COMPANY_ERROR', '');
define('ENTRY_COMPANY_TEXT', '');
define('ENTRY_GENDER', 'Sugu:');
define('ENTRY_GENDER_ERROR', 'Palun valige oma sugu.');
define('ENTRY_GENDER_TEXT', '*');
define('ENTRY_FIRST_NAME', 'Eesnimi:');
define('ENTRY_FIRST_NAME_ERROR', 'Teie eesnimes peab olema vhemalt ' . ENTRY_FIRST_NAME_MIN_LENGTH . ' thte.');
define('ENTRY_FIRST_NAME_TEXT', '*');
define('ENTRY_LAST_NAME', 'Perekonnanimi:');
define('ENTRY_LAST_NAME_ERROR', 'Teie perekonnanimes peab olema vhemalt ' . ENTRY_LAST_NAME_MIN_LENGTH . ' thte.');
define('ENTRY_LAST_NAME_TEXT', '*');
define('ENTRY_DATE_OF_BIRTH', 'Snniaeg:');
define('ENTRY_DATE_OF_BIRTH_ERROR', 'Teie snniaeg peab olema sellisel kujul: kuu/kuupev/aasta (niteks 05/21/1970)');
define('ENTRY_DATE_OF_BIRTH_TEXT', '* (niteks 05/21/1970)');
define('ENTRY_EMAIL_ADDRESS', 'E-posti aadress:');
define('ENTRY_EMAIL_ADDRESS_ERROR', 'Teie e-posti aadressis peab olema vhemalt ' . ENTRY_EMAIL_ADDRESS_MIN_LENGTH . ' themrki.');
define('ENTRY_EMAIL_ADDRESS_CHECK_ERROR', 'Teie e-posti aadress ei ole korrektne - palun viige sisse vajalikud parandused.');
define('ENTRY_EMAIL_ADDRESS_ERROR_EXISTS', 'Teie e-posti aadress on juba meie andmebaasis - palun logige sisse oma salasnaga vi looge konto mne teise e-posti aadressiga.');
define('ENTRY_EMAIL_ADDRESS_TEXT', '*');
define('ENTRY_STREET_ADDRESS', 'Tnav, maja number:');
define('ENTRY_STREET_ADDRESS_ERROR', 'Tnava nimi peab sisaldama vhemalt ' . ENTRY_STREET_ADDRESS_MIN_LENGTH . ' themrki.');
define('ENTRY_STREET_ADDRESS_TEXT', '*');
define('ENTRY_SUBURB', 'Korteri number:');
define('ENTRY_SUBURB_ERROR', '');
define('ENTRY_SUBURB_TEXT', '');
define('ENTRY_POST_CODE', 'Indeks:');
define('ENTRY_POST_CODE_ERROR', 'Indeks peab koosnema vhemalt ' . ENTRY_POSTCODE_MIN_LENGTH . ' numbrist.');
define('ENTRY_POST_CODE_TEXT', '*');
define('ENTRY_CITY', 'Linn:');
define('ENTRY_CITY_ERROR', 'Linna nimes peab olema vhemalt ' . ENTRY_CITY_MIN_LENGTH . ' themrki.');
define('ENTRY_CITY_TEXT', '*');
define('ENTRY_STATE', 'Maakond:');
define('ENTRY_STATE_ERROR', 'Maakonna nimes peab olema vhemalt ' . ENTRY_STATE_MIN_LENGTH . ' themrki.');
define('ENTRY_STATE_ERROR_SELECT', 'Palun valige maakond hpikmenst.');
define('ENTRY_STATE_TEXT', '*');
define('ENTRY_COUNTRY', 'Riik:');
define('ENTRY_COUNTRY_ERROR', 'Te peate valima hpikmenst riigi.');
define('ENTRY_COUNTRY_TEXT', '*');
define('ENTRY_TELEPHONE_NUMBER', 'Telefoninumber:');
define('ENTRY_TELEPHONE_NUMBER_ERROR', 'Telefoninumbris peab olema minimaalselt ' . ENTRY_TELEPHONE_MIN_LENGTH . ' numbrit.');
define('ENTRY_TELEPHONE_NUMBER_TEXT', '*');
define('ENTRY_FAX_NUMBER', 'Faksinumber:');
define('ENTRY_FAX_NUMBER_ERROR', '');
define('ENTRY_FAX_NUMBER_TEXT', '');
define('ENTRY_NEWSLETTER', 'Soovin uudiskirja:');
define('ENTRY_NEWSLETTER_TEXT', '');
define('ENTRY_NEWSLETTER_YES', 'Soovin');
define('ENTRY_NEWSLETTER_NO', 'Ei soovi');
define('ENTRY_NEWSLETTER_ERROR', '');
define('ENTRY_PASSWORD', 'Salasna:');
define('ENTRY_PASSWORD_ERROR', 'Teie salasnas peab olema minimaalselt ' . ENTRY_PASSWORD_MIN_LENGTH . ' themrki.');
define('ENTRY_PASSWORD_ERROR_NOT_MATCHING', 'Salasna ja salasna kinnitus ei hti.');
define('ENTRY_PASSWORD_TEXT', '*');
define('ENTRY_PASSWORD_CONFIRMATION', 'Salasna kinnitus:');
define('ENTRY_PASSWORD_CONFIRMATION_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT', 'Olemasolev salasna:');
define('ENTRY_PASSWORD_CURRENT_TEXT', '*');
define('ENTRY_PASSWORD_CURRENT_ERROR', 'Teie salasnas peab olema minimaalselt ' . ENTRY_PASSWORD_MIN_LENGTH . ' themrki.');
define('ENTRY_PASSWORD_NEW', 'Uus salasna:');
define('ENTRY_PASSWORD_NEW_TEXT', '*');
define('ENTRY_PASSWORD_NEW_ERROR', 'Teie salasnas peab olema minimaalselt ' . ENTRY_PASSWORD_MIN_LENGTH . ' themrki.');
define('ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING', 'Uus salasna ja salasna kinnitus ei hti.');
define('PASSWORD_HIDDEN', '--HIDDEN--');

define('FORM_REQUIRED_INFORMATION', '* Nutavad andmed');

// constants for use in tep_prev_next_display function
define('TEXT_RESULT_PAGE', 'Tulemused:');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS', 'Kuvan <b>%d</b> kuni <b>%d</b> (toodet <b>%d</b> -st)');
define('TEXT_DISPLAY_NUMBER_OF_ORDERS', 'Kuvan <b>%d</b> to <b>%d</b> (tellimust <b>%d</b> -st)');
define('TEXT_DISPLAY_NUMBER_OF_REVIEWS', 'Kuvan <b>%d</b> to <b>%d</b> (arvamust <b>%d</b> -st)');
define('TEXT_DISPLAY_NUMBER_OF_PRODUCTS_NEW', 'Kuvan <b>%d</b> to <b>%d</b> (uut toodet <b>%d</b> -st)');
define('TEXT_DISPLAY_NUMBER_OF_SPECIALS', 'Kuvan <b>%d</b> eripakkumist <b>%d</b> (of <b>%d</b> -st)');

define('PREVNEXT_TITLE_FIRST_PAGE', 'Esimene leht');
define('PREVNEXT_TITLE_PREVIOUS_PAGE', 'Eelmine leht');
define('PREVNEXT_TITLE_NEXT_PAGE', 'Jrgmine leht');
define('PREVNEXT_TITLE_LAST_PAGE', 'Viimane leht');
define('PREVNEXT_TITLE_PAGE_NO', 'Nr.');
define('PREVNEXT_TITLE_PREV_SET_OF_NO_PAGE', 'Eelmised');
define('PREVNEXT_TITLE_NEXT_SET_OF_NO_PAGE', 'Jrgmised');
define('PREVNEXT_BUTTON_FIRST', '<<ESIMENE');
define('PREVNEXT_BUTTON_PREV', '[<<Eelmine]');
define('PREVNEXT_BUTTON_NEXT', '[Jrgmine>>]');
define('PREVNEXT_BUTTON_LAST', 'VIIMANE>>');

define('IMAGE_BUTTON_ADD_ADDRESS', 'Lisa aadress');
define('IMAGE_BUTTON_ADDRESS_BOOK', 'Aadressiraamat');
define('IMAGE_BUTTON_BACK', 'Tagasi');
define('IMAGE_BUTTON_BUY_NOW', 'Ostan');
define('IMAGE_BUTTON_CHANGE_ADDRESS', 'Muudan aadressi');
define('IMAGE_BUTTON_CHECKOUT', 'Tellimused');
define('IMAGE_BUTTON_CONFIRM_ORDER', 'Tellimuse kinnitus');
define('IMAGE_BUTTON_CONTINUE', 'Jtkan');
define('IMAGE_BUTTON_CONTINUE_SHOPPING', 'Jtkan ostmist');
define('IMAGE_BUTTON_DELETE', 'Kustutan');
define('IMAGE_BUTTON_EDIT_ACCOUNT', 'Muudan oma andmeid');
define('IMAGE_BUTTON_HISTORY', 'Minu tellimused');
define('IMAGE_BUTTON_LOGIN', 'Login sisse');
define('IMAGE_BUTTON_IN_CART', 'Lisan ostukorvi');
define('IMAGE_BUTTON_NOTIFICATIONS', 'Mrkused');
define('IMAGE_BUTTON_QUICK_FIND', 'Kiirotsing');
define('IMAGE_BUTTON_REMOVE_NOTIFICATIONS', 'Eemaldamise mrkused');
define('IMAGE_BUTTON_REVIEWS', 'Arvamused');
define('IMAGE_BUTTON_SEARCH', 'Otsing');
define('IMAGE_BUTTON_SHIPPING_OPTIONS', 'Kohaletoimetamise valikud');
define('IMAGE_BUTTON_TELL_A_FRIEND', 'Soovitan sbrale');
define('IMAGE_BUTTON_UPDATE', 'Uuendan');
define('IMAGE_BUTTON_UPDATE_CART', 'Uuendan ostukorvi');
define('IMAGE_BUTTON_WRITE_REVIEW', 'Lisan arvamuse');

define('SMALL_IMAGE_BUTTON_DELETE', 'Kustutan');
define('SMALL_IMAGE_BUTTON_EDIT', 'Muudan');
define('SMALL_IMAGE_BUTTON_VIEW', 'Vaade');

define('ICON_ARROW_RIGHT', 'rohkem');
define('ICON_CART', 'Ostukorvis');
define('ICON_ERROR', 'Viga');
define('ICON_SUCCESS', 'Edukas');
define('ICON_WARNING', 'Hoiatus');

define('TEXT_GREETING_PERSONAL', 'Tere, <span class="greetUser">%s!</span> <br><br> .:<a href="%s"><u>Uued tooted</u></a>:.');
define('TEXT_GREETING_PERSONAL_RELOGON', '<small>Kui Te pole %s, palun <a href="%s"><u>logige sisse</u></a> oma kasutajanime ja parooliga.</small>');
define('TEXT_GREETING_GUEST', '');

define('TEXT_SORT_PRODUCTS', 'Sorteerin tooted ');
define('TEXT_DESCENDINGLY', 'kahanevalt');
define('TEXT_ASCENDINGLY', 'kasvavalt');
define('TEXT_BY', ' kuni ');

define('TEXT_REVIEW_BY', 'Autor: %s');
define('TEXT_REVIEW_WORD_COUNT', '%s sna');
define('TEXT_REVIEW_RATING', 'Hinnang: %s [%s]');
define('TEXT_REVIEW_DATE_ADDED', 'Lisamiskuupev: %s');
define('TEXT_NO_REVIEWS', 'Praegu arvamused puuduvad.');

define('TEXT_NO_NEW_PRODUCTS', 'Preagu uued tooted puuuvad.');

define('TEXT_UNKNOWN_TAX_RATE', 'Maksumr selgusetu');

define('TEXT_REQUIRED', '<span class="errorText">Nutav</span>');

define('ERROR_TEP_MAIL', '<font face="Verdana, Arial" size="2" color="#ff0000"><b><small>TEP ERROR:</small> Ei saa saata e-maili antud SMTP serveri kaudu. Palun kontrollige php.ini seadeid ja korrigeerige SMTP server, kui vajalik.</b></font>');
define('WARNING_INSTALL_DIRECTORY_EXISTS', 'Hoiatus: Installatsiooni kataloog eksisteerib: ' . dirname($HTTP_SERVER_VARS['SCRIPT_FILENAME']) . '/install. Palun eemaldage vi nimetage mber antud kataloog, see on vajalik turvakaalutlustel.');
define('WARNING_CONFIG_FILE_WRITEABLE', 'Hoiatus: pragu on vimalik kirjutada konfiguratsioonifaili: ' . dirname($HTTP_SERVER_VARS['SCRIPT_FILENAME']) . '/includes/configure.php. See on potentsiaalne turvarisk - palun seadke sellele failile iged kasutajaigused (chmod).');
define('WARNING_SESSION_DIRECTORY_NON_EXISTENT', 'Hoiatus: sessions kataloog ei eksisteeri: ' . tep_session_save_path() . '. Sessionnid ei toimi, kuni antud kataloog pole moodustatud.');
define('WARNING_SESSION_DIRECTORY_NOT_WRITEABLE', 'Hoiatus: Ma ei saa kirjutada sessions kataloogi: ' . tep_session_save_path() . '. Sessioonid ei tta, kuni on seatud iged kasutajaigused (chmod).');
define('WARNING_SESSION_AUTO_START', 'Hoiatus: session.auto_start on lubatud - palun keelake see php vimalus php.ini -failis ja tehke veebiserverile taaskivitus');
define('WARNING_DOWNLOAD_DIRECTORY_NON_EXISTENT', 'Hoiatus: The downloadable products kataloog ei eksisteeri: ' . DIR_FS_DOWNLOAD . '. Downloadable products ei tta, kuni see kataloog on moodustatud.');

define('TEXT_CCVAL_ERROR_INVALID_DATE', 'Sisestatud krediitkaardi aegumisthtaeg pole ige.<br>Palun kontrollige kuupeva ja sisestage andmed uuesti.');
define('TEXT_CCVAL_ERROR_INVALID_NUMBER', 'Sisestatud krediitkaardi number pole ige.<br>Palun kontrollige numbrit ja proovige uuesti.');
define('TEXT_CCVAL_ERROR_UNKNOWN_CARD', 'Esimsed neli numbrit sisestatud numbrist olid: %s<br>Kui see number on ige, ei aktsepteeri me seda tpi krediitkaarte.<br>Kui see oli vale, proovige uuesti.');

/*
  The following copyright announcement can only be
  appropriately modified or removed if the layout of
  the site theme has been modified to distinguish
  itself from the default osCommerce-copyrighted
  theme.

  For more information please read the following
  Frequently Asked Questions entry on the osCommerce
  support site:

  http://www.oscommerce.com/community.php/faq,26/q,50

  Please leave this comment intact together with the
  following copyright announcement.
*/

// FAQ SYSTEM 2.1
  define('BOX_INFORMATION_FAQ', 'FAQ');
// FAQ SYSTEM 2.1

// AJOUTS NICOLAS
define('TEXT_ICON_NEW_PRODUCT', 'NEW');

// BOF: More Pics 6
define('CLOSE_POPUP', 'close window');
define('MORE_PIC', 'Screenshots');
// EOF: More Pics 6

define('ERROR_INVALID_COUPON', 'You have entered an invalid coupon');
define('ERROR_USED_COUPON', 'You have already redeemed this coupon');


// Poll Box Text 
define('_RESULTS', 'Results'); 
define('_POLLS','Polls'); 
define('_VOTE', 'VOTE'); 
define('_VOTES', 'Votes'); 
define('_NOPOLLS','No eligible polls'); 
define('_NOPOLLSCONTENT','There are no polls that you are eligible for, however you can still view the results of other polls<br><br><a href="pollbooth.php">['._POLLS.']');  
define('_POLLS_HEADER','Polls-Header');


// Nouveau code pour TVA_INTRACOM_v3.0
define('ENTRY_COMPANY_ERROR', 'The Company Name must contain a minimum of ' . ENTRY_COMPANY_MIN_LENGTH . ' characters.');
define('ENTRY_COMPANY_TEXT', 'Only if you want we bill the Company for your order');
// Fin nouveau code pour TVA_INTRACOM_v3.0

// Ajout pour TVA_INTRACOM_v3.0
define('ENTRY_TVA_INTRACOM', 'N TVA intracom :');
define('ENTRY_TVA_INTRACOM_ERROR', 'The VAT intracom number of your Company must contain a minimum of ' . ENTRY_TVA_INTRACOM_MIN_LENGTH . ' characters.');
define('ENTRY_TVA_INTRACOM_TEXT', 'your VAT registration number is MANDATORY for any shipment within the EU');
define('ENTRY_CONTROL_TVA_INTRACOM', 'After checking, your intracom. VAT is not correct. Leave it blank if you don\'t know it.<br>For info, it must be structured like this:<br>Germany: \'DE\' + 9 numeric characters<br>Austria: \'AT\' + 9 numeric and alphanumeric characters<br>Belgium : \'BE\' + 9 numeric characters<br>Denmark : \'DK\' + 8 numeric characters<br>Spain: \'ES\' + 9 characters<br>Finland : \'FI\' + 8 numeric characters<br>France: \'FR\' + 2 figures (informatic key) + N SIREN (9 figures)<br>United Kingdom: \'GB\' + 9 numeric characters<br>Greece: \'EL\' + 9 numeric characters<br>Irlande : \'IE\' + 8 numeric and alphabetic characters<br>Italy : \'IT\' + 11 numeric characters<br>Luxembourg: \'LU\' + 8 numeric characters<br>Netherlands: \'NL\' + 12 alphanumeric characters, one of them a letter<br>Portugal : \'PT\' + 9 numeric characters<br>Sweden : \'SE\' + 12 numeric characters<br>Cyprus : \'CY\' + 8 numeric characters and 1 alphabetic character<br>Estonia : \'EE\' + 9 numeric characters<br>Hungary : \'HU\' + 8 numeric characters<br>Latvia : \'LV\' + 11 numeric characters<br>Lithuania : \'LT\' + 9 or 12 numeric characters<br>Malta : \'MT\' + 8 numeric characters<br>Poland : \'PL\' + 10 numeric characters<br>Slovakia : \'SK\' + 9 or 10 numeric characters<br>Czech Republic : \'CZ\' + 8 or 9 or 10 numeric characters<br>Slovania : \'SI\' + 8 numeric characters'); 
define('ENTRY_NO_VERIF_TVA_INTRACOM', 'Impossible to check your VAT number: leave it empty');
  // Begin update for TVA_INTRACOM_v3.9
	define('ENTRY_CONTROL_TVA_INTRACOM_COUNTRY', 'The intracom. VAT number does not correspond to the indicated country. Leave it blank if you don\'t know it.');
	// End update for TVA_INTRACOM_v3.9
// Fin ajout pour TVA_INTRACOM_v3.0
//mod for heardabout conribution:
define('ENTRY_HEARDABOUT', 'How do you know us?');
//end of mod for heardabout conribution


//Short description in products modules Start
define('DESCR_READ_MORE', '<FONT color=blue> +++</FONT>'); // ... read more.
//Short description in products modules End

define('IMAGE_NEW_PRODUCT', '... + New');
define('IMAGE_SPECIAL_PRODUCT', '... + Discount');
define('IMAGE_BUTTON_CART_VIEW',' ' );
define('IMAGE_BUTTON_CART_CHECKOUT','' );
define('ENTRY_SPONSORSHIP_EMAIL','Enter the email of your godson and save money !' );
define('MY_SPONSORSHIP','MY SPONSORSHIP' );
define('TEXT_LINK_TO_ALL_GODSON','See all the godsons' );
define('HEADING_TRACKING','Parcel number' );
define('HEADING_STATUS','Status' );
define('HEADING_STATUS_DATE','Status date' );


?>
