<?php
if( !defined( 'FWR_INSTALLER' ) ) die( 'Direct access is not permitted!' );
/**
 * Generic Installer
 *
 * Database install script for contributions
 * Dependencies -  installer.php
 * 
 * @package Generic Installer
 * @link http://www.fwrmedia.co.uk
 * @copyright Copyright 2008, Robert Fisher, FWR Media 
 * @author Robert Fisher, FWR Media, http://www.fwrmedia.co.uk 
 * @lastdev $Author:: Rob                                              $:  Author of last commit
 * @lastmod $Date:: 2009-11-29 13:12:25 +0000 (Sun, 29 Nov 2009)       $:  Date of last commit
 * @version $Rev:: 107                                                 $:  Revision of last commit
 * @Id $Id:: installer_class.php 107 2009-11-29 13:12:25Z Rob          $:  Full Details 
 * @filesource
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
class installer_class {
  
  var $autoIncrement = false;
  var $package = "FWR Media Generic Installer version 1.0a";
  var $stage = 1;
  var $token = "";
  var $install = array('error' => array());
  var $db = null;
  
  function installer_class() {
    define( 'STAGE_ONE_SMALL_TEXT', 'Si aucun bouton rouge, c\'est que vous tes prts  installer.' );
    define( 'STAGE_TWO_SMALL_TEXT', 'Rsultat de l\'installation.' );
    define( 'INSTALL_SUCCESS', 'Base de donne bien installe.<p />Effacer les 2 fichiers<br />... installer.php et installer_class.php.' );
    $this->token = $this->random_value( '10' );
    $this->manageStage();
    $this->db = new independent_database_functions;
  }
  
  function manageStage() {
    $session_token = null;
    $session_stage = null;
    if ( isset( $_SESSION['token'] ) ) {
      $session_token = $_SESSION['token'];
      unset( $_SESSION['token'] );
    }
    if ( isset( $_SESSION['stage'] ) ) {
      $session_stage = $_SESSION['stage'];
      unset( $_SESSION['stage'] );
    }
    if ( isset( $_POST['token'], $session_token, $session_stage ) ) {
      if ( $session_token == $_POST['token'] ) {
        if ( isset( $_POST['auto_increment'] ) ) {
          $this->autoIncrement = $_POST['auto_increment'];
        }
        $this->stage = $session_stage+1;
      } else {
        $this->stage = 1;
        return false;
      }
    } else {
      $this->stage = 1;
      return false;
    }
  }
  
  function tablesExist( $tables ) {
    if ( is_array( $tables ) ) {
      $query = "SHOW TABLES FROM `" . DB_DATABASE . "`";
      $result = $this->db->query( $query );
      while ( $table = $this->db->fetchArray( $result ) ) {
        $existing_tables[] = $table['Tables_in_' . DB_DATABASE];
      }
      $this->db->free( $result );
      foreach ( $tables as $tablename => $query ) {
        if ( in_array( $tablename, $existing_tables ) ) {
          return true;
        }
      }
    }
    return false;
  }
  
  function fields_exist( $table_to_field_array ) {
    
    if ( is_array( $table_to_field_array ) ) {
      foreach ( $table_to_field_array as $table => $field ) {
        //if( !key($field) ) return false;
        $query = "SHOW COLUMNS FROM `" . $table . "` LIKE '" . key( $field ) . "'";
        $result = $this->db->query( $query );
        $row = $this->db->fetchArray( $result );
        $this->db->free( $result );
        if( $row === false ) {
          return false;
        } 
      }
    } else {
      return true;
    }
    return true; 
  }
  
  function configExists( $config_inserts ) {
    if ( $this->autoIncrement === false ) {
      $this->getAutoIncrement();
      $increment = $this->autoIncrement;
    }
    foreach ( $config_inserts['group'] as $numkey => $detailArray ) {
      $query = "SELECT COUNT(configuration_group_id)
      FROM " . TABLE_CONFIGURATION_GROUP . " WHERE configuration_group_title = '" . $detailArray['configuration_group_title'] . "'";
      $result = $this->db->query( $query );
      $count_array = $this->db->fetchArray( $result );
      $this->db->free( $result );
      if ( $count_array['COUNT(configuration_group_id)'] > 0 ) {
        return true;
      }
      if ( is_array( $detailArray['configuration'] ) ) {
        foreach ( $detailArray['configuration'] as $numkey => $detail ) {
          $query = "SELECT COUNT(configuration_id)
          FROM " . TABLE_CONFIGURATION . " WHERE configuration_key = '" . $detail['configuration_key'] . "'";
          $result = $this->db->query( $query );
          $count_array = $this->db->fetchArray( $result );
          $this->db->free( $result );
          if ( $count_array['COUNT(configuration_id)'] > 0 ) {
            return true;
          }
        } 
      }
      $increment++;
    }
  }
  
  function getAutoIncrement() {
    $query = "SHOW TABLE STATUS FROM `" . DB_DATABASE . "` LIKE '" . TABLE_CONFIGURATION_GROUP . "'";
    $result = $this->db->query( $query );
    $row = $this->db->fetchArray( $result );
    $this->db->free( $result );
    $this->autoIncrement = $row['Auto_increment'];
  }
  
  function showStatus( $errors ) {
    
    echo '    <div class="spacer">&nbsp;</div>' . "\n";
    if ( false !== $errors ) {
      echo '    <div class="messageerror">Au moins une erreur. Pas possible d\'installer.<p />Database ' . DB_DATABASE . ' n\'a pas t modife.<p />Vrifiez votre Base ' . DB_DATABASE . '.</div>' . "\n";
    } else {
      echo '    <div class="messagesuccess">Pas d\'erreur, l\'installation continue.</div>' . "\n";
    }
  }
  
  function installerMessage() {
?>
    <div id="message_header">Installer Messages: Stage - <?php echo $this->stage; ?></div>
<?php
    switch ( true ) {
      case ( $this->stage == 1 ):
      echo '    <div class="smalltext">' . STAGE_ONE_SMALL_TEXT . '</div>' . "\n";
      break;
      case ( $this->stage == 2 ):
      echo '    <div class="smalltext">' . STAGE_TWO_SMALL_TEXT . '</div>' . "\n";
      break;      
      default:
    }
?>
    <div class="spacer">&nbsp;</div>
<?php
  }
  
  function drawPostForm( $submit_name = 'Install' ) {
    echo '      <div class="spacer">&nbsp;</div>' . "\n";
    echo '      <form name="install_stages" action="' . basename($_SERVER['SCRIPT_NAME']) . '" method = "post">' . "\n";
    echo '        <input type="hidden" name="auto_increment" value="' . $this->autoIncrement . '" />' . "\n";
    echo '        <input type="hidden" name="token" value="' . $this->token . '" />' . "\n";
    echo '        <input type="submit" value="' . $submit_name . '" />' . "\n";
    echo '      </form>' . "\n";
  }
  
  function implementInstall( $config_inserts, $tables_to_add, $tables_to_alter, $fields_to_add, $fields_to_alter ) {
    if ( is_array( $config_inserts['group'] ) ) {
      foreach ( $config_inserts['group'] as  $numkey => $groupdetail ) {
        if ( !isset( $increment ) ) $increment = $this->autoIncrement;
        $sql = "
        INSERT INTO `" . TABLE_CONFIGURATION_GROUP . "` (configuration_group_id,configuration_group_title,configuration_group_description,sort_order,visible)
        VALUES ('" . $increment . "', '" . $groupdetail['configuration_group_title'] . "', '" . $groupdetail['configuration_group_description'] . "', '" . $groupdetail['sort_order'] . "', '" . $groupdetail['visible'] . "')
        ";
        if ( !$result = $this->db->query( $sql ) ) {
          $this->install['error'][] = $sql;
          break;
        }
        if ( is_array( $groupdetail['configuration'] ) ) {
          foreach( $groupdetail['configuration'] as $numkey => $detail ) {
            $sql = "
            INSERT INTO `" . TABLE_CONFIGURATION . "` (configuration_title,configuration_key,configuration_value,configuration_description,configuration_group_id,sort_order,last_modified,date_added,use_function,set_function)
            VALUES ('" . $detail['configuration_title'] . "', '" . $detail['configuration_key'] . "', '" . $detail['configuration_value'] . "', '" . $detail['configuration_description'] . "', '" . $increment . "', '" . $detail['sort_order'] . "', '" . $detail['last_modified'] . "', '" . $detail['date_added'] . "', '" . $detail['use_function'] . "', '" . $detail['set_function'] . "')
            ";
            if ( !$result = $this->db->query( $sql ) ) {
              $this->install['error'][] = $sql;
              break;
            }
          }
        }
        $increment++;
      }
    } // End configuration installer
    if ( is_array( $tables_to_add ) ) {
      foreach ( $tables_to_add as $table => $sql ) {
        if ( !$result = $this->db->query( $sql ) ) {
          $this->install['error'][] = $sql;
        }
      }
    }
    if ( is_array( $tables_to_alter ) ) {
      foreach ( $tables_to_alter as $table => $alter ) {
        if ( !$result = $this->db->query( $alter[key( $alter )] ) ) {
          $this->install['error'][] = $alter[key( $alter )];
        }
      }
    }
    if ( is_array( $fields_to_add ) ) {
      foreach ( $fields_to_add as $table => $field ) {
        if ( !$result = $this->db->query( $field[key( $field )] ) ) {
          $this->install['error'][] = $field[key( $field )];
        }
      }
    }
    if ( is_array( $fields_to_alter ) ) {
      foreach ( $fields_to_alter as $table => $alter ) {
        if ( !$result = $this->db->query( $alter[key( $alter )] ) ) {
          $this->install['error'][] = $alter[key( $alter )];
        }
      }
    }
  }
  
  function outputInstallSuccess() {
    echo '    <div id="messages_container">' . "\n";
    echo '      <div class="success">' . INSTALL_SUCCESS . '</div>' . "\n";
    echo '    </div>' . "\n";
  }
  
  function outputErrors() {
    echo '    <div id="messages_container">' . "\n";
    echo '      <ul>' . "\n";
    foreach ( $this->install['error'] as $numkey => $query ) {
      echo '    <li class="error">' . $query . '</li>' . "\n";
    }
    echo '      </ul>' . "\n";
    echo '    </div>' . "\n";
  }
  
  // Standard oscommerce function
  function random_value( $length, $type = 'mixed' ) {
    if ( ( $type != 'mixed' ) && ( $type != 'chars' ) && ( $type != 'digits' ) ) return false;

    $rand_value = '';
    while ( strlen( $rand_value ) < $length ) {
      if ( $type == 'digits' ) {
        $char = $this->randval( 0,9 );
      } else {
        $char = chr( $this->randval( 0,255 ) );
      }
      if ( $type == 'mixed' ) {
        if ( ctype_alnum( $char ) ) $rand_value .= $char;
      } elseif ( $type == 'chars' ) {
        if ( ctype_alpha( $char ) ) $rand_value .= $char;
      } elseif ( $type == 'digits' ) {
        if ( ctype_digit( $char ) ) $rand_value .= $char;
      }
    }

    return $rand_value;
  }
  
  // standard oscommerce function
  function randval( $min = null, $max = null ) {
    static $seeded;

    if ( !isset( $seeded ) ) {
      mt_srand( (double)microtime()*1000000 );
      $seeded = true;
    }

    if ( isset( $min ) && isset( $max ) ) {
      if ( $min >= $max ) {
        return $min;
      } else {
        return mt_rand( $min, $max );
      }
    } else {
      return mt_rand();
    }
  }
  
  /*
  * Just html presentation below here
  */
  function showHeader() {
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="en">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1" />
<title><?php echo $this->package; ?></title>
<style type="text/css">
body {
  font-family: verdana, sans-serif;
  font-size: 8pt;
  margin: 0;
  padding: 0;
  background-color: #FCFCE8;
}
form {
margin: 0;
padding: 0;
}
input {
margin: 0;
padding: 0;
}
#container {
  margin: 3em 6em 6em 6em;
  border: 1px solid #ccc;
}
#inner_container {
  margin: 0.1em;
  padding: 0.5em;
  background-color: #FFFFDD;
  height: 500px;
  position: relative;
}
#header {
  background-color: #660000;
  width: 100%;
  color: #9e5d5d;
  font-size: 20pt;
  height: 3em;
}
.error {
  color: red;
  padding: 0.5em;
}
.success {
  color: green;
  padding: 0.5em;
}
.messagesuccess {
  border: 1px solid green;
  color: green;
  padding: 1em;
  background-color: #ffffcc;
}
.messageerror {
  border: 1px solid red;
  color: red;
  padding: 1em;
  background-color: #FFE6E6;
}
.spacer {
  padding: 0.5em;
}
#message_header {
  color: #660000;
  padding: 0.5em;
  font-size: 14pt;
  font-family: verdana;  
}
#fwrfooter a { 
  position: absolute;
  bottom: 0.3em;
  padding-left: 2em;
  text-decoration: none;
  color: #660000;
}
.smalltext {
  font-weight: 8pt;
  font-family: tahoma, verdana;
}
#messages_container {
  background-color: #fff;
  padding: 0.5em;
  border: 1px solid #ccc;
  width: 50%;
}
.dormant {
  color: orange;
  padding: 0.5em;
  text-decoration: italic;
}
</style>
</head>
<body>
<div id="container">
  <div id="header"><span style="padding: 0.5em; position: relative;  top: 30%;"><?php echo $this->package; ?></span></div>
  <div id="inner_container">
<?php
$this->installerMessage();
  }
  
  function showFooter() {
?>
    <div id="fwrfooter"><a href="http://www.fwrmedia.co.uk" title="PHP - MySQL - osCommerce by FWR Media"> ... another script by FWR Media</a></div>
  </div>
</div>
</body>
</html>
<?php
  }
} // End class

class independent_database_functions {
  
  var $link;
  
  function independent_database_functions() {
    $this->connect();
  }
  
  function connect() {
    if( is_resource( $this->link ) ) {
      return;
    }
    $this->link = mysql_connect( DB_SERVER, DB_SERVER_USERNAME, DB_SERVER_PASSWORD );
    if ( !$this->link ) {
      die( 'Cannot connect to database : ' . mysql_error() );
    }
    $db_selected = mysql_select_db( DB_DATABASE, $this->link );
    if ( !$db_selected ) {
      die ( 'Cannot select ' . DB_DATABASE . ' : ' . mysql_error() );
    }
  }
  
  function query( $query ) {
    $result = mysql_query( $query, $this->link );
    if ( !$result ) {
      return false;
    }
    return $result;
  }
  
  function fetchArray( $result ) {
    return mysql_fetch_array( $result, MYSQL_ASSOC );
  }
  
  function free( $result ) {
    return mysql_free_result( $result );
  }
  
  function close() {
    return mysql_close( $this->link );
  }
} // End class 
?>