<?php
/*
  $Id: validations.php 1739 2007-12-20 00:52:16Z hpdl $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
*/

  ////////////////////////////////////////////////////////////////////////////////////////////////
  //
  // Function    : tep_validate_email
  //
  // Arguments   : email   email address to be checked
  //
  // Return      : true  - valid email address
  //               false - invalid email address
  //
  // Description : function for validating email address that conforms to RFC 822 specs
  //
  //               This function is converted from a JavaScript written by
  //               Sandeep V. Tamhankar (stamhankar@hotmail.com). The original JavaScript
  //               is available at http://javascript.internet.com
  //
  // Sample Valid Addresses:
  //
  //    first.last@host.com
  //    firstlast@host.to
  //    "first last"@host.com
  //    "first@last"@host.com
  //    first-last@host.com
  //    first.last@[123.123.123.123]
  //
  // Invalid Addresses:
  //
  //    first last@host.com
  //
  //
  ////////////////////////////////////////////////////////////////////////////////////////////////
  function tep_validate_email($email) {
    $valid_address = true;

    $mail_pat = '^(.+)@(.+)$';
    $valid_chars = "[^] \(\)<>@,;:\.\\\"\[]";
    $atom = "$valid_chars+";
    $quoted_user='(\"[^\"]*\")';
    $word = "($atom|$quoted_user)";
    $user_pat = "^$word(\.$word)*$";
    $ip_domain_pat='^\[([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\.([0-9]{1,3})\]$';
    $domain_pat = "^$atom(\.$atom)*$";

    if (eregi($mail_pat, $email, $components)) {
      $user = $components[1];
      $domain = $components[2];
      // validate user
      if (eregi($user_pat, $user)) {
        // validate domain
        if (eregi($ip_domain_pat, $domain, $ip_components)) {
          // this is an IP address
      	  for ($i=1;$i<=4;$i++) {
      	    if ($ip_components[$i] > 255) {
      	      $valid_address = false;
      	      break;
      	    }
          }
        }
        else {
          // Domain is a name, not an IP
          if (eregi($domain_pat, $domain)) {
            /* domain name seems valid, but now make sure that it ends in a valid TLD or ccTLD
               and that there's a hostname preceding the domain or country. */
            $domain_components = explode(".", $domain);
            // Make sure there's a host name preceding the domain.
            if (sizeof($domain_components) < 2) {
              $valid_address = false;
            } else {
              $top_level_domain = strtolower($domain_components[sizeof($domain_components)-1]);
              // Allow all 2-letter TLDs (ccTLDs)
              if (eregi('^[a-z][a-z]$', $top_level_domain) != 1) {
                $tld_pattern = '';
                // Get authorized TLDs from text file
                $tlds = file(DIR_WS_INCLUDES . 'tld.txt');
                while (list(,$line) = each($tlds)) {
                  // Get rid of comments
                  $words = explode('#', $line);
                  $tld = trim($words[0]);
                  // TLDs should be 3 letters or more
                  if (eregi('^[a-z]{3,}$', $tld) == 1) {
                    $tld_pattern .= '^' . $tld . '$|';
                  }
                }
                // Remove last '|'
                $tld_pattern = substr($tld_pattern, 0, -1);
                if (eregi("$tld_pattern", $top_level_domain) == 0) {
                    $valid_address = false;
                }
              }
            }
          }
          else {
      	    $valid_address = false;
      	  }
      	}
      }
      else {
        $valid_address = false;
      }
    }
    else {
      $valid_address = false;
    }
    if ($valid_address && ENTRY_EMAIL_ADDRESS_CHECK == 'true') {
      if (!checkdnsrr($domain, "MX") && !checkdnsrr($domain, "A")) {
        $valid_address = false;
      }
    }
    return $valid_address;
  }

  ////////////////////////////////////////////////////////////////////////////////////////////////
  //
  // Function   : tep_verif_tva 
  // Arguments   : num_tva   VAT INTRACOM number to be checked
  // Return      : 'true'  - valid VAT number
  //               'false' - invalid VAT number
	//               'no_verif' - problem with the europa server
  //
  // Description : function for validating VAT INTRACOM number through the europa.eu.int server
  //							 By JeanLuc (February, 5th 2004) 
  //							 Updated by JeanLuc (July, 23th 2004) 
	//							 Updated by JeanLuc (May, 22th 2006) using europa.eu.int server webservice (SOAP) via nusoap.php class (Dietrich Ayala)            
  //
  // Valid VAT INTRACOM number structure:
  //    Austria 				AT + 9 numeric and alphanumeric characters 
  //    Belgium 				BE + 9 numeric characters 
  //    Denmark 				DK + 8 numeric characters 
  //    Finland 				FI + 8 numeric characters 
  //    France 					FR + 2 chiffres (informatic key) + N SIREN (9 figures) 
  //    Germany 				DE + 9 numeric characters 
  //    Greece 					EL + 9 numeric characters 
  //    Irlande 				IE + 8 numeric and alphabetic characters 
  //    Italy 					IT + 11 numeric characters 
  //    Luxembourg 			LU + 8 numeric characters 
  //    Netherlands 		NL + 12 alphanumeric characters, one of them a letter 
  //    Portugal 				PT + 9 numeric characters 
  //    Spain 					ES + 9 characters 
  //    Sweden 					SE + 12 numeric characters 
  //    United Kingdom 	GB + 9 numeric characters 
  //
  //    Cyprus 					CY + 8 numeric characters + 1 alphabetic character  
  //    Estonia 				EE + 9 numeric characters 
  //    Hungary 				HU + 8 numeric characters 
  //    Latvia 					LV + 11 numeric characters
  //    Lithuania				LT + 9 or 12 numeric characters 
  //    Malta 					MT + 8 numeric characters 
  //    Poland	 				PL + 10 numeric characters 
  //    Slovakia  			SK + 9 or 10 numeric characters 
  //    Czech Republic 	CZ + 8 or 9 or 10 numeric characters 
  //    Slovenia 				SI + 8 numeric characters
  //
  ////////////////////////////////////////////////////////////////////////////////////////////////
function tep_verif_tva($num_tva){	 
	$prefix = substr($num_tva, 0, 2);
	$tva = substr($num_tva, 2);
	
	if (array_search($prefix, tep_get_tva_intracom_array() ) === false) {
		return 'false';
	}
	
	require_once('includes/classes/nusoap.php');
	$param = array('countryCode' => $prefix, 'vatNumber' => $tva );
	$client = new soapclient_nusoap( 'http://ec.europa.eu/taxation_customs/vies/api/checkVatPort' ); 
	$response = $client->call('checkVat', $param);
	
	if ($client->fault) { 
    return 'no_verif';
  }elseif ($response['valid']=='true'){
	  return 'true'; 
  }else{
	  $myVerif = 'false';
	} 
	return $myVerif;
}

  ////////////////////////////////////////////////////////////////////////////////////////////////
  //
  // Function   : tep_get_tva_intracom_array 
  // Return     : array
  //
  // Description : Array for linking the ISO code of each country of EU and the first 2 letters of the vat number
  //               (for Greece or France metropolitaine , it's different)
  //             
  //							  by JeanLuc Friez (July, 23th 2004)
  //							  Update by Madenio (July, 22nd 2007) Update for new EU member countries (Romania + Bulgaria)              
  //
  ////////////////////////////////////////////////////////////////////////////////////////////////
function tep_get_tva_intracom_array() {
	$intracom_array = array('AT'=>'AT',    //Austria
													'BE'=>'BE',    //Belgium
													'DK'=>'DK',    //Denmark
													'FI'=>'FI',    //Finland
													'FR'=>'FR',    //France
													'FX'=>'FR',    //France mtropolitaine
													'DE'=>'DE',    //Germany
													'GR'=>'EL',    //Greece
													'IE'=>'IE',    //Irland
													'IT'=>'IT',    //Italy
													'LU'=>'LU',    //Luxembourg
													'NL'=>'NL',    //Netherlands
													'PT'=>'PT',    //Portugal
													'ES'=>'ES',    //Spain
													'SE'=>'SE',    //Sweden
													'GB'=>'GB',    //United Kingdom
													'CY'=>'CY',    //Cyprus
													'EE'=>'EE',    //Estonia
													'HU'=>'HU',    //Hungary
													'LV'=>'LV',    //Latvia
													'LT'=>'LT',    //Lithuania
													'MT'=>'MT',    //Malta
													'PL'=>'PL',    //Poland
													'SK'=>'SK',    //Slovakia
													'CZ'=>'CZ',    //Czech Republic
													'SI'=>'SI',    //Slovania
													'RO'=>'RO',    //Romania			
				    							'BG'=>'BG');   //Bulgaria 
	return $intracom_array;
}
?>
