<?php
/*
 * $Id: opensi.php4,v 1.1 2007/09/23 20:04:34 jm Exp $
 * 
 * Created on 15 mai 07 by AEL Sarl for
 * 
 * osCommerce, Open Source E-Commerce Solutions
 * http://www.oscommerce.com
 *
 * Copyright (c) 2003 osCommerce
 *
 * Released under the GNU General Public License
 * 
 */

require('standard.php');

class opensi extends standard {

	var $export;
	
	function opensi() {
		parent::standard();
		$this->content_type = "text/xml";
		$this->key = 'opensi';
		$this->description = 'Module OpenSI';
	}
	
	function _write_accounts_chart() {
		$comptes = array();
		foreach ($this->accounts as $account_number => $account_values) {
			$compte = $this->export->create_element('compte');
			$compte->set_attribute('numero', $account_number);
			$compte->set_attribute('intitule', $account_values['name']);
			if ($account_values['type'] == 'CUS')
				$compte->set_attribute('type', "C");
			else
				$compte->set_attribute('type', "G");
			$comptes[] = $compte;
		}
		
		return $comptes;
	}
	
	function _write_account($row, $handler) {
		$lines = array();
		$current_handler = $handler;
		$row['operation_mode'] = 'credit';
		while ($current_handler != null) {
			if ($current_handler->value != 0) {
				$row['account_name'] = $current_handler->account_name;
				$row['account_number'] = $current_handler->account_number;
				$row['products_excluded_tax'] = $current_handler->value;
				$lines[] = $this->_write_line($row);
			}
			$current_handler = $current_handler->next_handler;
		}
		
		return $lines;
	}
	
	function _write_tax_account($row) {
		$lines = array();
		$handler = $this->tax_manager;
		$row['operation_mode'] = 'credit';
		while ($handler != null) {
			if ($handler->value != 0) {
				$row['account_name'] = $handler->account_name;
				$row['account_number'] = $handler->account_number;
				$row['products_excluded_tax'] = $handler->value;
				$lines[] = $this->_write_line($row);
			}
			$handler = $handler->next_handler;
		}
		
		return $lines;
	}
	
	function _write_customer_account($row) {
		$row['operation_mode'] = 'debit';
		$row['account_name'] = $this->customer_account['name'];
		$row['account_number'] = $this->customer_account['number'];
		$row['products_excluded_tax'] = $row['total_included_tax'];
		$lines[] = $this->_write_line($row);
		
		return $lines;
	}
	
	function _write_shipping_account($row) {
		$lines = array();
		// write the shipping operation
		$row['operation_mode'] = 'credit';
		$row['account_name'] = $this->shipping_account['name'];
		$row['account_number'] = $this->shipping_account['number'];
		$lines[] = $this->_write_line($row);
		
		return $lines;
	}
	
	function _write_line($row) {
		$op = $this->export->create_element($row['operation_mode']);
		$op->set_attribute('date', $row['invoice_date']);
		$op->set_attribute('libelle', $row['account_name']);
		$op->set_attribute('compte', $row['account_number']);
		$op->set_attribute('montant', tep_round($row['products_excluded_tax'], 2) * 100);
		$op->set_attribute('numpiece', $row['invoice_number']);
		$op->set_attribute('echeance', '');
		$op->set_attribute('lettre', '');
		
		return $op;
		
	}
	
	function _merge($parent, $childs) {
		foreach ($childs as $child)
			$child = $parent->append_child($child);
		// returns the last created child
		return $child;
	}
	
	function _export($row) {
		static $previous_row = null;
		$roots = $this->export->get_elements_by_tagname('compta_opensi');
		$root = $roots[0];
		
		// manage the shipping part at end of order process
		// ie when a new order needs to be processed
		// or when there is no more order (last order is a null row)
		if ($row == null ||
		    ($row != null && $previous_row != null && $row['orders_id'] != $previous_row['orders_id'])) {
		 	$this->_manage_shipping($previous_row['orders_id']);
		 	
		 	$ecriture = $this->export->create_element('ecriture');
			$ecriture->set_attribute('periode', substr($previous_row['invoice_date'], 2));
			$ecriture->set_attribute('journal', SALES_JOURNAL);
			
			// check the total amounts for debugging only
			// $fp = fopen(DIR_FS_ADMIN . 'share.log', 'a');
			// fwrite($fp, 'balance sur : ' . $previous_row['total_included_tax'] . "\n");
			// fclose($fp);
			//$this->_balance($previous_row['total_included_tax']);
			// write the excluded tax amount ordered by account number
		 	$operation = $this->_merge($ecriture, $this->_write_account($previous_row, $this->sale_manager));
		 	// write all taxes values
		 	$operation = $this->_merge($ecriture, $this->_write_tax_account($previous_row));
		 	// write the customer part, included tax
		 	$operation = $this->_merge($ecriture, $this->_write_customer_account($previous_row));
		 	
		 	$ecriture = $this->_merge($root, array($ecriture));
		 	$this->tax_manager->clear();
		 	$this->sale_manager->clear();
		}
		
		if ($row != null) {
			$this->_handle_current_row($row);
			// store the old row
			$previous_row = $row;
		}
		
		return $root;
	}
	
	function export($query) {
		/**
		 * Export the formatted lines of data
		 * 
		 * @param query     a SQL Result of fetched informations
		 */
	
		header('Content-type: ' . $this->content_type);
    header('Content-disposition: attachment; filename=' . EXPORT_INVOICES_FILENAME);
    $this->export = domxml_new_doc('1.0');
    $root = $this->export->create_element('compta_opensi');
    $root = $this->export->append_child($root);
    
    $this->_merge($root, $this->_write_accounts_chart());
    
    while ($row = tep_db_fetch_array($query))
    	$root = $this->_export($row);
    	
    // now manage the last order
    $root = $this->_export(null);
    
    return $this->export->dump_mem(true, 'utf-8');
	}
	
} 
?>
