<?php
/*
  $Id: reclamaposte.php, v 1.7 24/01/2009 delete (forum oscommerce-fr.info) $

  This script is not included in the original version of osCommerce

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce
  
  Fichier commun de configuration 
*/

if(!function_exists('file_put_contents')) 
{
    function file_put_contents($filename, $data, $file_append = false) {
        $fp = fopen($filename, (!$file_append ? 'w+' : 'a+'));
        if(!$fp) {
            trigger_error('file_put_contents - erreur écriture dans.', E_USER_ERROR);
            return;
        }
        fputs($fp, $data);
        fclose($fp);
    }
}
// !! PARTIE IMPORTANTE !!
define('STATUS_COMMANDE_DELIVREE', '100008'); //numero du statut commande = a livre

//define('TRACKING_DB_FIELD', 'tracking_id'); // Nom du champ 'No De Colis' dans la table order_history - Merci à Phocea
define('TRACKING_DB_FIELD', 'track_num'); // Nom du champ 'No De Colis' dans la table order_history - Merci à Phocea

// Indiquer s'il s'agit d'un contrat PRO : génération d'un fichier XLS ou d'envois standards fichier de réclamation format PDF
define('CONTRAT_PRO', true);
//define('CONTRAT_PRO', false);

define('COLIPOSTE_MAX_DAYS', 90);// Nb de jours max à inclure dans la recherche - Mettre 0 pour pas de limite
define('COLIPOSTE_MAX_RECLAMATION', 30); //Indique le nombre max de colis à lister par réclamation
define('COLIPOSTE_TO_BE_ARCHIVED', 30); // Nombre de jours   partir duquel on consid re le colis a pass  en archiv 
define('COLIPOSTE_IN_TEST', 0); // Mettre à 1 pour activer le mode test. Les commandes ne seront pas avancé au status COLIPOSTE_RECLAMATION_DEMANDE

// Adresses email (contrat PRO) 
define('LAPOSTE_EMAIL_DESTINATAIRE', STORE_OWNER_EMAIL_ADDRESS) ; // Adresse du destinataire (en théorie la poste, demandé à votre contact PRO son adresse email)
define('LAPOSTE_EMAIL_EXPEDITEUR', STORE_OWNER_EMAIL_ADDRESS) ; // Adresse de l'expéditeur
define('LAPOSTE_EMAIL_REPONSE', STORE_OWNER_EMAIL_ADDRESS) ; // Adresse de réponse (en théorie identique à celle de l'expéditeur)

// FIN DE LA PARTIE IMPORTANTE //

 
// Librairie PDF
//
if (CONTRAT_PRO){
  // Répertoire contenant la librairie PHP Write Excel                            	
  $wxls_library_path = 'wxls/' ;
} else {
	 define('FPDF_FONTPATH','fpdf/font/');
}


// Répertoire Temporaire
//$tmp_dir = '/tmp' ; // en dédié
$tmp_dir = DIR_FS_ADMIN . 'tmp' ; // en mutualisé
 
 
 
 
 // Urls and Parameters du site coliposte
// Mise à jour du 4 juin 2010 par artiz et kisscoolix
//$main_url = 'http://www.coliposte.net';
//$url_params = '/gp/services/main.jsp?m=10003005&colispart=';
$main_url = 'http://www.colissimo.fr/portail_colissimo/';
$url_params = 'suivre.do?m=10003005&colispart=';
// Fin mise à jour du 4 juin 2010


// Fichiers temporaires
$cookie_filename = $tmp_dir . '/laposte.txt' ;
$tmp_xls = $tmp_dir . '/tmp.xls' ;


// Fichiers de traitement  
$fremboursements = $tmp_dir . "/laposte.remboursements.txt" ; 
$flist = $tmp_dir . "/laposte.list.txt" ; 
$output_xls_name = 'laposte_' . date('Y-m-d', time()) . '.xls' ;

if ( ! file_exists($flist) ) file_put_contents($flist, '') ; // création si inexistant

define('COLIPOSTE_LIVRAISON_RETARD', 5); 
define('COLIPOSTE_LIVRAISON_OK', 10);
define('COLIPOSTE_LIVRAISON_TRANSIT', 15);
define('COLIPOSTE_LIVRAISON_UNKNOWN', 20);
define('COLIPOSTE_REMBOURSEMENT_IMPOSSIBLE', 25);
define('COLIPOSTE_RECLAMATION_DEMANDE', 35);
define('COLIPOSTE_RECLAMATION_REMBOURSE', 40);
define('COLIPOSTE_ARCHIVE', 50);
define('COLIPOSTE_NO_INFORMATION', 90);
define('COLIPOSTE_ERREUR_MD5', 99);
 

$etat['COLIPOSTE_LIVRAISON_RETARD']['description'] = 'Livraison effectu&eacute; en retard';
$etat['COLIPOSTE_LIVRAISON_RETARD']['icon'] = 'icon_reclamaposte_late.png';
$etat['COLIPOSTE_LIVRAISON_OK']['description'] = 'Livraison effectu&eacute; &agrave; temps';
$etat['COLIPOSTE_LIVRAISON_OK']['icon'] = 'icon_reclamaposte_ok.png';
$etat['COLIPOSTE_LIVRAISON_TRANSIT']['description'] = 'Livraison toujours en cours';
$etat['COLIPOSTE_LIVRAISON_TRANSIT']['icon'] = 'icon_reclamaposte_transit.png';
$etat['COLIPOSTE_NO_INFORMATION']['description'] = 'Etat de livraison inconnu - A v&eacute;rifier';
$etat['COLIPOSTE_NO_INFORMATION']['icon'] = 'icon_reclamaposte_unknown.png';
$etat['COLIPOSTE_REMBOURSEMENT_IMPOSSIBLE']['description'] = 'Pas de remboursement possible sur cette livraison';
$etat['COLIPOSTE_REMBOURSEMENT_IMPOSSIBLE']['icon'] = 'icon_reclamaposte_impossible.png';
$etat['COLIPOSTE_RECLAMATION_DEMANDE']['description'] = 'Livraison en retard - R&eacute;clamation effectu&eacute;';
$etat['COLIPOSTE_RECLAMATION_DEMANDE']['icon'] = 'icon_reclamaposte_reclamation.png';
$etat['COLIPOSTE_RECLAMATION_REMBOURSE']['description'] = 'Livraison en retard - Remboursement reçu';
$etat['COLIPOSTE_RECLAMATION_REMBOURSE']['icon'] = 'icon_reclamaposte_cash.png';
$etat['COLIPOSTE_NONE']['description'] = 'Colissimo &agrave; v&eacute;rifier';
$etat['COLIPOSTE_NONE']['icon'] = 'icon_reclamaposte_none.png';
$etat['COLIPOSTE_ARCHIVE']['description'] = 'Coliposte trop ancien et archiv&eacute;';
$etat['COLIPOSTE_ARCHIVE']['icon'] = 'icon_reclamaposte_archive.png';
$etat['COLIPOSTE_ERREUR_MD5']['description'] = 'Status pr&eacute;sent sur site de la poste non reconnu';
$etat['COLIPOSTE_ERREUR_MD5']['icon'] = 'icon_reclamaposte_md5_error.png';

/* A priori ne pas toucher les lignes suivantes */

$status= array();
// Status livré
$status['1f9c469ab21e5b64cbb31f45f01b5c77']['description'] = 'Livr&eacute;';
$status['1f9c469ab21e5b64cbb31f45f01b5c77']['notification_client'] = 1;
$status['1f9c469ab21e5b64cbb31f45f01b5c77']['notification_email_template'] = 1;
$status['1f9c469ab21e5b64cbb31f45f01b5c77']['remboursable'] = 'true';
$status['1f9c469ab21e5b64cbb31f45f01b5c77']['initial_transit'] = 'false';
$status['9cd60418e9cbad03ff699ed6504081c4']['description'] = 'Livr&eacute; Conforme';
$status['9cd60418e9cbad03ff699ed6504081c4']['notification_client'] = 1;
$status['9cd60418e9cbad03ff699ed6504081c4']['notification_email_template'] = 1;
$status['9cd60418e9cbad03ff699ed6504081c4']['remboursable'] = 'true';
$status['9cd60418e9cbad03ff699ed6504081c4']['initial_transit'] = 'false';
$status['01e49e7741634eb5617ebf63f0d40769']['description'] = 'Colis livr&eacute;';
$status['01e49e7741634eb5617ebf63f0d40769']['notification_client'] = 1;
$status['01e49e7741634eb5617ebf63f0d40769']['notification_email_template'] = 1;
$status['01e49e7741634eb5617ebf63f0d40769']['remboursable'] = 'true';
$status['01e49e7741634eb5617ebf63f0d407694']['initial_transit'] = 'false';
// Status présentés
$status['16b4a42d0412966610c5f7d9504a4414']['description'] = 'Colis en instance &agrave; la poste, destinataire avis&eacute; disposant de 15 jours pour aller le retirer';
$status['16b4a42d0412966610c5f7d9504a4414']['notification_client'] = 1;
$status['16b4a42d0412966610c5f7d9504a4414']['notification_email_template'] = 1;
$status['16b4a42d0412966610c5f7d9504a4414']['remboursable'] = 'true';
$status['16b4a42d0412966610c5f7d9504a4414']['initial_transit'] = 'false';
$status['59ead25a6f21d854c4c9499fac033040']['description'] = 'Colis en instance &agrave; la poste, destinataire avis&eacute; disposant de 15 jours pour aller le retirer';
$status['59ead25a6f21d854c4c9499fac033040']['notification_client'] = 1;
$status['59ead25a6f21d854c4c9499fac033040']['notification_email_template'] = 1;
$status['59ead25a6f21d854c4c9499fac033040']['remboursable'] = 'true';
$status['59ead25a6f21d854c4c9499fac033040']['initial_transit'] = 'false';
$status['e4b21bccc77644f76bbdb2b297297e3e']['description'] = 'Destinataire absent lors de la premi&egrave;re livraison, seconde pr&eacute;sentation pr&eacute;vue';
$status['e4b21bccc77644f76bbdb2b297297e3e']['notification_client'] = 1;
$status['e4b21bccc77644f76bbdb2b297297e3e']['notification_email_template'] = 1;
$status['e4b21bccc77644f76bbdb2b297297e3e']['remboursable'] = 'true';
$status['e4b21bccc77644f76bbdb2b297297e3e']['initial_transit'] = 'false';
$status['2785b7f3103de9c8778d9110a91427ef']['description'] = 'Colis &agrave; disposition du destinaire au bureau de poste';
$status['2785b7f3103de9c8778d9110a91427ef']['notification_client'] = 1;
$status['2785b7f3103de9c8778d9110a91427ef']['notification_email_template'] = 1;
$status['2785b7f3103de9c8778d9110a91427ef']['remboursable'] = 'true';
$status['2785b7f3103de9c8778d9110a91427ef']['initial_transit'] = 'false';
$status['2785b7f3103de9c8778d9110a91427ef']['description'] = 'Colis &agrave; disposition du destinataire';
$status['2785b7f3103de9c8778d9110a91427ef']['notification_client'] = 1;
$status['2785b7f3103de9c8778d9110a91427ef']['notification_email_template'] = 1;
$status['2785b7f3103de9c8778d9110a91427ef']['remboursable'] = 'true';
$status['2785b7f3103de9c8778d9110a91427ef']['initial_transit'] = 'false';
$status['347eae829981f03a1036e463103b1eab']['description'] = 'Colis ou accus&eacute; de r&eacute;ception &agrave; signer mis &agrave; disposition dans la boîte postale';
$status['347eae829981f03a1036e463103b1eab']['notification_client'] = 1;
$status['347eae829981f03a1036e463103b1eab']['notification_email_template'] = 1;
$status['347eae829981f03a1036e463103b1eab']['remboursable'] = 'true';
$status['347eae829981f03a1036e463103b1eab']['initial_transit'] = 'false';
$status['2c2482aac5701e5b297ab57a13e4eff0']['description'] = 'Colis &agrave; disposition du destinataire 5 jours dans le cityssimo';
$status['2c2482aac5701e5b297ab57a13e4eff0']['notification_client'] = 1;
$status['2c2482aac5701e5b297ab57a13e4eff0']['notification_email_template'] = 1;
$status['2c2482aac5701e5b297ab57a13e4eff0']['remboursable'] = 'true';
$status['2c2482aac5701e5b297ab57a13e4eff0']['initial_transit'] = 'false';
$status['e9c66a355d98c1e919be3a518d7e1ed6']['description'] = 'Colis r&eacute;expedi&eacute; &agrave; la demande du destinataire vers l\'adresse de son choix';
$status['e9c66a355d98c1e919be3a518d7e1ed6']['notification_client'] = 1;
$status['e9c66a355d98c1e919be3a518d7e1ed6']['notification_email_template'] = 1;
$status['e9c66a355d98c1e919be3a518d7e1ed6']['remboursable'] = 'true';
$status['e9c66a355d98c1e919be3a518d7e1ed6']['initial_transit'] = 'false';
// Status non remboursable
$status['55869ad6917e3ce8d4984381e1e12cf7']['description'] = 'Adresse compl&eacute;t&eacute;e ou corrig&eacute;e par nos services, colis redirig&eacute; vers le bon site de distribution';
$status['55869ad6917e3ce8d4984381e1e12cf7']['notification_client'] = 1;
$status['55869ad6917e3ce8d4984381e1e12cf7']['notification_email_template'] = 1;
$status['55869ad6917e3ce8d4984381e1e12cf7']['remboursable'] = 'false';
$status['55869ad6917e3ce8d4984381e1e12cf7']['initial_transit'] = 'false';
$status['96123b9900beb4f4678e5f68dd188fd3']['description'] = 'Colis retourn&eacute; &agrave; l\'exp&eacute;diteur car refus&eacute; par le destinataire';
$status['96123b9900beb4f4678e5f68dd188fd3']['notification_client'] = 1;
$status['96123b9900beb4f4678e5f68dd188fd3']['notification_email_template'] = 1;
$status['96123b9900beb4f4678e5f68dd188fd3']['remboursable'] = 'false';
$status['96123b9900beb4f4678e5f68dd188fd3']['initial_transit'] = 'false';
$status['7dbbaaddb321f689f440cc075f8fd762']['description'] = 'Colis retourn&eacute; &agrave; l\'exp&eacute;diteur car le destinataire du colis n\'habite pas &agrave; l\'adresse indiqu&eacute;e';
$status['7dbbaaddb321f689f440cc075f8fd762']['notification_client'] = 1;
$status['7dbbaaddb321f689f440cc075f8fd762']['notification_email_template'] = 1;
$status['7dbbaaddb321f689f440cc075f8fd762']['remboursable'] = 'false';
$status['7dbbaaddb321f689f440cc075f8fd762']['initial_transit'] = 'false';
$status['52a7f30e1efc9308be8672f3eed5f099']['description'] = 'Colis en cours de r&eacute;acheminement vers sont exp&eacute;diteur';
$status['52a7f30e1efc9308be8672f3eed5f099']['notification_client'] = 1;
$status['52a7f30e1efc9308be8672f3eed5f099']['notification_email_template'] = 1;
$status['52a7f30e1efc9308be8672f3eed5f099']['remboursable'] = 'false';
$status['52a7f30e1efc9308be8672f3eed5f099']['initial_transit'] = 'false';
// Status en transit
$status['df5635740e757b728e27a34afbb650d3']['description'] = 'Pris en charge de le r&eacute;seau Colissimo';
$status['df5635740e757b728e27a34afbb650d3']['notification_client'] = 1;
$status['df5635740e757b728e27a34afbb650d3']['notification_email_template'] = 1;
$status['df5635740e757b728e27a34afbb650d3']['remboursable'] = 'true';
$status['df5635740e757b728e27a34afbb650d3']['initial_transit'] = 'true';
$status['0c63b90af6406567388adb71ff695557']['description'] = 'Colis pris en charge dans le réseau';
$status['0c63b90af6406567388adb71ff695557']['notification_client'] = 1;
$status['0c63b90af6406567388adb71ff695557']['notification_email_template'] = 1;
$status['0c63b90af6406567388adb71ff695557']['remboursable'] = 'true';
$status['0c63b90af6406567388adb71ff695557']['initial_transit'] = 'true';
$status['5b1092eb53574ac02768d57a0d4439da']['description'] = 'Trait&eacute; par le site de livraison';
$status['5b1092eb53574ac02768d57a0d4439da']['notification_client'] = 1;
$status['5b1092eb53574ac02768d57a0d4439da']['notification_email_template'] = 1;
$status['5b1092eb53574ac02768d57a0d4439da']['remboursable'] = 'true';
$status['5b1092eb53574ac02768d57a0d4439da']['initial_transit'] = 'true';
$status['c51b33cdba95ea6113435739b8259c82']['description'] = 'Colis arriv&eacute; dans le r&eacute;seau partenaire du pays destinataire';
$status['c51b33cdba95ea6113435739b8259c82']['notification_client'] = 1;
$status['c51b33cdba95ea6113435739b8259c82']['notification_email_template'] = 1;
$status['c51b33cdba95ea6113435739b8259c82']['remboursable'] = 'false';
$status['c51b33cdba95ea6113435739b8259c82']['initial_transit'] = 'true';
$status['92fa28d7867746aef5bec47b3df19baa']['description'] = 'Colis sorti du territoire de d&eacute;part';
$status['92fa28d7867746aef5bec47b3df19baa']['notification_client'] = 1;
$status['92fa28d7867746aef5bec47b3df19baa']['notification_email_template'] = 1;
$status['92fa28d7867746aef5bec47b3df19baa']['remboursable'] = 'false';
$status['92fa28d7867746aef5bec47b3df19baa']['initial_transit'] = 'true';
$status['9e21e939b22305a64b1a2f57fa25dd39']['description'] = 'Colis arriv&eacute; sur site, livraison en pr&eacute;paration';
$status['9e21e939b22305a64b1a2f57fa25dd39']['notification_client'] = 1;
$status['9e21e939b22305a64b1a2f57fa25dd39']['notification_email_template'] = 1;
$status['9e21e939b22305a64b1a2f57fa25dd39']['remboursable'] = 'true';
$status['9e21e939b22305a64b1a2f57fa25dd39']['initial_transit'] = 'true';
$status['aacb86be1581c96c891abd3b58c6ae75']['description'] = 'Colis arriv&eacute; sur site, livraison en pr&eacute;paration';
$status['aacb86be1581c96c891abd3b58c6ae75']['notification_client'] = 1;
$status['aacb86be1581c96c891abd3b58c6ae75']['notification_email_template'] = 1;
$status['aacb86be1581c96c891abd3b58c6ae75']['remboursable'] = 'true';
$status['aacb86be1581c96c891abd3b58c6ae75']['initial_transit'] = 'true';
$status['5b1092eb53574ac02768d57a0d4439da']['description'] = 'Colis trait&eacute; par le site de livraison';
$status['5b1092eb53574ac02768d57a0d4439da']['notification_client'] = 1;
$status['5b1092eb53574ac02768d57a0d4439da']['notification_email_template'] = 1;
$status['5b1092eb53574ac02768d57a0d4439da']['remboursable'] = 'true';
$status['5b1092eb53574ac02768d57a0d4439da']['initial_transit'] = 'true';
$status['4b24a332b2743e942c03ebb27fa10e09']['description'] = 'Colis en instance en douane';
$status['4b24a332b2743e942c03ebb27fa10e09']['notification_client'] = 1;
$status['4b24a332b2743e942c03ebb27fa10e09']['notification_email_template'] = 1;
$status['4b24a332b2743e942c03ebb27fa10e09']['remboursable'] = 'false';
$status['4b24a332b2743e942c03ebb27fa10e09']['initial_transit'] = 'true';
$status['5154c07d974c9c47f78570054f5ae923']['description'] = 'Colis d&eacute;pos&eacute; au bureau de Poste pour acheminement';
$status['5154c07d974c9c47f78570054f5ae923']['notification_client'] = 1;
$status['5154c07d974c9c47f78570054f5ae923']['notification_email_template'] = 1;
$status['5154c07d974c9c47f78570054f5ae923']['remboursable'] = 'true';
$status['5154c07d974c9c47f78570054f5ae923']['initial_transit'] = 'true';
$status['1b957501644bdc6db068c59343c592c6']['description'] = 'Colis d&eacute;pos&eacute; au bureau de Poste pour acheminement';
$status['1b957501644bdc6db068c59343c592c6']['notification_client'] = 1;
$status['1b957501644bdc6db068c59343c592c6']['notification_email_template'] = 1;
$status['1b957501644bdc6db068c59343c592c6']['remboursable'] = 'true';
$status['1b957501644bdc6db068c59343c592c6']['initial_transit'] = 'true';
$status['f5425b49ecb3c62d559d53ee5024a1df']['description'] = 'Colis en cours d\'acheminement dans notre r&eacute;seau';
$status['f5425b49ecb3c62d559d53ee5024a1df']['notification_client'] = 1;
$status['f5425b49ecb3c62d559d53ee5024a1df']['notification_email_template'] = 1;
$status['f5425b49ecb3c62d559d53ee5024a1df']['remboursable'] = 'true';
$status['f5425b49ecb3c62d559d53ee5024a1df']['initial_transit'] = 'true';
$status['3322af623f3fb3b9a19a9387320e4b07']['description'] = 'Colis en cours d\'acheminement dans notre r&eacute;seau';
$status['3322af623f3fb3b9a19a9387320e4b07']['notification_client'] = 1;
$status['3322af623f3fb3b9a19a9387320e4b07']['notification_email_template'] = 1;
$status['3322af623f3fb3b9a19a9387320e4b07']['remboursable'] = 'true';
$status['3322af623f3fb3b9a19a9387320e4b07']['initial_transit'] = 'true';
$status['f7c7f9ea682c979b0dae4b15814d2c1b']['description'] = 'Colis pr&eacute;par&eacute; pour en effectuer la livraison';
$status['f7c7f9ea682c979b0dae4b15814d2c1b']['notification_client'] = 1;
$status['f7c7f9ea682c979b0dae4b15814d2c1b']['notification_email_template'] = 1;
$status['f7c7f9ea682c979b0dae4b15814d2c1b']['remboursable'] = 'true';
$status['f7c7f9ea682c979b0dae4b15814d2c1b']['initial_transit'] = 'true';
$status['bf6056ab2447f9b18fa5d709db858276']['description'] = 'Colis pr&eacute;par&eacute; pour en effectuer la livraison';
$status['bf6056ab2447f9b18fa5d709db858276']['notification_client'] = 1;
$status['bf6056ab2447f9b18fa5d709db858276']['notification_email_template'] = 1;
$status['bf6056ab2447f9b18fa5d709db858276']['remboursable'] = 'true';
$status['bf6056ab2447f9b18fa5d709db858276']['initial_transit'] = 'true';

// Mise à jour des statuts
// 10 juin 2009
$status['1939c6ac92bb0aafdee4a7d91a8e68d2']['description'] = 'Destinataire absent lors de la premi&egrave;re livraison, seconde pr&eacute;sentation pr&eacute;vue';
$status['1939c6ac92bb0aafdee4a7d91a8e68d2']['notification_client'] = 0;
$status['1939c6ac92bb0aafdee4a7d91a8e68d2']['notification_email_template'] = 0;
$status['1939c6ac92bb0aafdee4a7d91a8e68d2']['remboursable'] = 'true';
$status['1939c6ac92bb0aafdee4a7d91a8e68d2']['initial_transit'] = 'false';
// 20 juin 2009
$status['875b2a969f61ffa1dac744e5177771bb']['description'] = 'Colis pris en charge dans notre r&eacute;seau';
$status['875b2a969f61ffa1dac744e5177771bb']['notification_client'] = 0;
$status['875b2a969f61ffa1dac744e5177771bb']['notification_email_template'] = 0;
$status['875b2a969f61ffa1dac744e5177771bb']['remboursable'] = 'true';
$status['875b2a969f61ffa1dac744e5177771bb']['initial_transit'] = 'true';
// 02 septembre 2009
$status['1bceede347f1d3c9724cc1ca22646d2d']['description'] = 'Colis pris en charge dans le r&eacute;seau';
$status['1bceede347f1d3c9724cc1ca22646d2d']['notification_client'] = 0;
$status['1bceede347f1d3c9724cc1ca22646d2d']['notification_email_template'] = 0;
$status['1bceede347f1d3c9724cc1ca22646d2d']['remboursable'] = 'true';
$status['1bceede347f1d3c9724cc1ca22646d2d']['initial_transit'] = 'true';
// 17 septembre 2009
$status['96ade23a372f91681bdfec4f6a782591']['description'] = 'Votre colis est arriv&eacute; sur son site de distribution';
$status['96ade23a372f91681bdfec4f6a782591']['notification_client'] = 0;
$status['96ade23a372f91681bdfec4f6a782591']['notification_email_template'] = 0;
$status['96ade23a372f91681bdfec4f6a782591']['remboursable'] = 'true';
$status['96ade23a372f91681bdfec4f6a782591']['initial_transit'] = 'true';

$status['50351273836c25e142bcf935d176aaf6']['description'] = 'Le destinataire &eacute;tait absent lors de la premi&egrave;re livraison. Votre colis sera present&eacute; une nouvelle fois le prochain jour ouvr&eacute;';
$status['50351273836c25e142bcf935d176aaf6']['notification_client'] = 0;
$status['50351273836c25e142bcf935d176aaf6']['notification_email_template'] = 0;
$status['50351273836c25e142bcf935d176aaf6']['remboursable'] = 'true';
$status['50351273836c25e142bcf935d176aaf6']['initial_transit'] = 'false';

$status['6d8dc2dbc66bc05698427954949a5594']['description'] = 'Votre colis est pris en charge par La Poste. Il est en cours d\'acheminement.';
$status['6d8dc2dbc66bc05698427954949a5594']['notification_client'] = 0;
$status['6d8dc2dbc66bc05698427954949a5594']['notification_email_template'] = 0;
$status['6d8dc2dbc66bc05698427954949a5594']['remboursable'] = 'true';
$status['6d8dc2dbc66bc05698427954949a5594']['initial_transit'] = 'true';

$status['7b239af5fcb9e519b9b5045c00f9b7e7']['description'] = 'Votre colis est disponible au bureau de poste. Votre destinataire, une fois l\'avis d\'instance re&ccedil;u, dispose de 10 jours ouvr&eacute;s pour venir retirer le colis sur pr&eacute;sentation d\'une pi&egrave;ce d\'identit&eacute;.';
$status['7b239af5fcb9e519b9b5045c00f9b7e7']['notification_client'] = 0;
$status['7b239af5fcb9e519b9b5045c00f9b7e7']['notification_email_template'] = 0;
$status['7b239af5fcb9e519b9b5045c00f9b7e7']['remboursable'] = 'true';
$status['7b239af5fcb9e519b9b5045c00f9b7e7']['initial_transit'] = 'false'; 

$status['d52afb959c5b85603ac401e83dba3ab9']['description'] = 'Votre colis est livr&eacute;.';
$status['d52afb959c5b85603ac401e83dba3ab9']['notification_client'] = 0;
$status['d52afb959c5b85603ac401e83dba3ab9']['notification_email_template'] = 0;
$status['d52afb959c5b85603ac401e83dba3ab9']['remboursable'] = 'true';
$status['d52afb959c5b85603ac401e83dba3ab9']['initial_transit'] = 'false';

$status['ef80d2e921210bc661e9873e0b0df7bb']['description'] = 'Votre colis est disponible au bureau de poste. Votre destinataire, une fois l\'avis d\'instance re&ccedil;u, dispose de 10 jours ouvr&eacute;s pour venir retirer le colis sur pr&eacute;sentation d\'une pi&egrave;ce d\'identit&eacute;.';
$status['ef80d2e921210bc661e9873e0b0df7bb']['notification_client'] = 0;
$status['ef80d2e921210bc661e9873e0b0df7bb']['notification_email_template'] = 0;
$status['ef80d2e921210bc661e9873e0b0df7bb']['remboursable'] = 'true';
$status['ef80d2e921210bc661e9873e0b0df7bb']['initial_transit'] = 'false';

$status['72e2b31e7335ee02e3fc972e1d278519']['description'] = 'Votre colis est livr&eacute; au gardien ou &agrave; un des voisins.';
$status['72e2b31e7335ee02e3fc972e1d278519']['notification_client'] = 0;
$status['72e2b31e7335ee02e3fc972e1d278519']['notification_email_template'] = 0;
$status['72e2b31e7335ee02e3fc972e1d278519']['remboursable'] = 'true';
$status['72e2b31e7335ee02e3fc972e1d278519']['initial_transit'] = 'false';

$status['09160652504bbe50ef4843c9b9c87992']['description'] = 'Votre colis a &eacute;t&eacute; d&eacute;pos&eacute; au bureau de poste d\'exp&eacute;dition.';
$status['09160652504bbe50ef4843c9b9c87992']['notification_client'] = 0;
$status['09160652504bbe50ef4843c9b9c87992']['notification_email_template'] = 0;
$status['09160652504bbe50ef4843c9b9c87992']['remboursable'] = 'true';
$status['09160652504bbe50ef4843c9b9c87992']['initial_transit'] = 'true';

$status['9cf2ec2e5711e4bb47350859f96cb3f2']['description'] = 'Le destinataire du colis n\'habite pas &agrave; l\'adresse indiqu&eacute;e. Le colis est retourn&eacute; &agrave; l\exp&eacute;diteur.';
$status['9cf2ec2e5711e4bb47350859f96cb3f2']['notification_client'] = 0;
$status['9cf2ec2e5711e4bb47350859f96cb3f2']['notification_email_template'] = 0;
$status['9cf2ec2e5711e4bb47350859f96cb3f2']['remboursable'] = 'false';
$status['9cf2ec2e5711e4bb47350859f96cb3f2']['initial_transit'] = 'true';

// 28 septembre 2009
$status['42bd4c0093b4bb137b1499c24eff2e3e']['description'] = 'La livraison de votre colis a &eacute;t&eacute; report&eacute;e pour absence du destinataire ou cas de force majeur.';
$status['42bd4c0093b4bb137b1499c24eff2e3e']['notification_client'] = 0;
$status['42bd4c0093b4bb137b1499c24eff2e3e']['notification_email_template'] = 0;
$status['42bd4c0093b4bb137b1499c24eff2e3e']['remboursable'] = 'true';
$status['42bd4c0093b4bb137b1499c24eff2e3e']['initial_transit'] = 'true';

// 05 octobre 2009
$status['C59107ADABD57AB1FB8378D0FF7F6ED8']['description'] = 'Votre colis s\'apprête &agrave; sortir du pays d\'origine.';
$status['C59107ADABD57AB1FB8378D0FF7F6ED8']['notification_client'] = 0;
$status['C59107ADABD57AB1FB8378D0FF7F6ED8']['notification_email_template'] = 0;
$status['C59107ADABD57AB1FB8378D0FF7F6ED8']['remboursable'] = 'false';
$status['C59107ADABD57AB1FB8378D0FF7F6ED8']['initial_transit'] = 'true';

$status['55CF47B22311AA226C7DA00FA5544CCA']['description'] = 'Votre colis est sorti du bureau d\'&eacute;change. Il est en cours d\'acheminement dans le pays de destination.';
$status['55CF47B22311AA226C7DA00FA5544CCA']['notification_client'] = 0;
$status['55CF47B22311AA226C7DA00FA5544CCA']['notification_email_template'] = 0;
$status['55CF47B22311AA226C7DA00FA5544CCA']['remboursable'] = 'false';
$status['55CF47B22311AA226C7DA00FA5544CCA']['initial_transit'] = 'true';

$status['2BF9E99BD11C065537E5F5021CA2A932']['description'] = 'Votre colis est arriv&eacute; dans le pays de destination.';
$status['2BF9E99BD11C065537E5F5021CA2A932']['notification_client'] = 0;
$status['2BF9E99BD11C065537E5F5021CA2A932']['notification_email_template'] = 0;
$status['2BF9E99BD11C065537E5F5021CA2A932']['remboursable'] = 'false';
$status['2BF9E99BD11C065537E5F5021CA2A932']['initial_transit'] = 'true';

$status['3A413BA198F8AC0709DC713BB9F052E6']['description'] = 'Votre colis n\'a pas pu &ecirc;tre distribu&eacute; par manque d\'information. Merci de prendre contact avec notre service client via le formulaire disponible sur Internet, afin de fournir les compl&eacute;ments n&eacute;cessaires.';
$status['3A413BA198F8AC0709DC713BB9F052E6']['notification_client'] = 0;
$status['3A413BA198F8AC0709DC713BB9F052E6']['notification_email_template'] = 0;
$status['3A413BA198F8AC0709DC713BB9F052E6']['remboursable'] = 'false';
$status['3A413BA198F8AC0709DC713BB9F052E6']['initial_transit'] = 'true';

// 07 octobre 2009
$status['753DCBF6C7430ADCB41369C5ABED4C39']['description'] = 'L\'adresse de votre colis est incompl&egrave;te. Nous recherchons la partie non renseign&eacute;e pour le livrer.';
$status['753DCBF6C7430ADCB41369C5ABED4C39']['notification_client'] = 0;
$status['753DCBF6C7430ADCB41369C5ABED4C39']['notification_email_template'] = 0;
$status['753DCBF6C7430ADCB41369C5ABED4C39']['remboursable'] = 'true';
$status['753DCBF6C7430ADCB41369C5ABED4C39']['initial_transit'] = 'true';

// 08 octobre 2009
$status['cb09443c764d34bfb32b6da565f146af']['description'] = 'Votre colis est arriv&eacute; par erreur sur un site. Il est en cours de r&eacute;acheminement vers son site de distribution.';
$status['cb09443c764d34bfb32b6da565f146af']['notification_client'] = 0;
$status['cb09443c764d34bfb32b6da565f146af']['notification_email_template'] = 0;
$status['cb09443c764d34bfb32b6da565f146af']['remboursable'] = 'true';
$status['cb09443c764d34bfb32b6da565f146af']['initial_transit'] = 'true';

$status['5c47571b8e4ac17561496386f29b7794']['description'] = 'Votre colis est livr&eacute;';
$status['5c47571b8e4ac17561496386f29b7794']['notification_client'] = 0;
$status['5c47571b8e4ac17561496386f29b7794']['notification_email_template'] = 0;
$status['5c47571b8e4ac17561496386f29b7794']['remboursable'] = 'true';
$status['5c47571b8e4ac17561496386f29b7794']['initial_transit'] = 'false';

// 13 octobre 2009
$status['8B7B323FF51943C9489BE19806A5F532']['description'] = 'Facture manquante, votre colis est retenu en douane. Etude du dossier par la douane.';
$status['8B7B323FF51943C9489BE19806A5F532']['notification_client'] = 0;
$status['8B7B323FF51943C9489BE19806A5F532']['notification_email_template'] = 0;
$status['8B7B323FF51943C9489BE19806A5F532']['remboursable'] = 'false';
$status['8B7B323FF51943C9489BE19806A5F532']['initial_transit'] = 'true';

// 28 octobre 2009
$status['DABEFAE9BEADEDAD79EE481B6D84AAC6']['description'] = 'Votre colis est pr&ecirc;t &agrave; &ecirc;tre exp&eacute;di&eacute;. Il n\'est pas encore pris en charge par La Poste.';
$status['DABEFAE9BEADEDAD79EE481B6D84AAC6']['notification_client'] = 0;
$status['DABEFAE9BEADEDAD79EE481B6D84AAC6']['notification_email_template'] = 0;
$status['DABEFAE9BEADEDAD79EE481B6D84AAC6']['remboursable'] = 'true';
$status['DABEFAE9BEADEDAD79EE481B6D84AAC6']['initial_transit'] = 'tue';

//  30 decembre 2009
$status['3c8859b8a1cf5992ca7af315f0c157a4']['description'] = 'Votre colis est en attente de distribution et sera livr&eacute; prochainement.';
$status['3c8859b8a1cf5992ca7af315f0c157a4']['notification_client'] = 0;
$status['3c8859b8a1cf5992ca7af315f0c157a4']['notification_email_template'] = 0;
$status['3c8859b8a1cf5992ca7af315f0c157a4']['remboursable'] = 'true';
$status['3c8859b8a1cf5992ca7af315f0c157a4']['initial_transit'] = 'true';

// 13 avril 2010
$status['130dc4477afc212a9f956c1579e23e2e']['description'] = 'Votre Colis est livr&eacute;;';
$status['130dc4477afc212a9f956c1579e23e2e']['notification_client'] = 0;
$status['130dc4477afc212a9f956c1579e23e2e']['notification_email_template'] = 0;
$status['130dc4477afc212a9f956c1579e23e2e']['remboursable'] = 'true';
$status['130dc4477afc212a9f956c1579e23e2e']['initial_transit'] = 'false';

$status['1d8cbe65f12dce1d6f635235d91c13c8']['description'] = 'Votre colis est pris en charge par laposte. Il est en cours d\'acheminement';
$status['1d8cbe65f12dce1d6f635235d91c13c8']['notification_client'] = 0;
$status['1d8cbe65f12dce1d6f635235d91c13c8']['notification_email_template'] = 0;
$status['1d8cbe65f12dce1d6f635235d91c13c8']['remboursable'] = 'true';
$status['1d8cbe65f12dce1d6f635235d91c13c8']['initial_transit'] = 'true';

$status['693654993fd03e7cb25736ff637c77d1']['description'] = 'Le destinataire &eacute;tait absent lors de la premi&egrave;re livraison. Votre colis sera present&eacute; une nouvelle fois le prochain jour ouvr&eacute;';
$status['693654993fd03e7cb25736ff637c77d1']['notification_client'] = 0;
$status['693654993fd03e7cb25736ff637c77d1']['notification_email_template'] = 0;
$status['693654993fd03e7cb25736ff637c77d1']['remboursable'] = 'true';
$status['693654993fd03e7cb25736ff637c77d1']['initial_transit'] = 'true';

$status['af07dd4ed1bd433e84fd5e05750c253e']['description'] = 'Votre colis est disponible au bureau de poste. Le destinataire, une fois l\'avis d\'instance re&ccedil;u, dispose de 15 jours consecutifs pour retirer le colis sur pr&eacute;sentation de son bon de retrait et d\'une pi&egrave;ce d\'identit&eacute;.';
$status['af07dd4ed1bd433e84fd5e05750c253e']['notification_client'] = 0;
$status['af07dd4ed1bd433e84fd5e05750c253e']['notification_email_template'] = 0;
$status['af07dd4ed1bd433e84fd5e05750c253e']['remboursable'] = 'true';
$status['af07dd4ed1bd433e84fd5e05750c253e']['initial_transit'] = 'false'; 

$status['212a4af0ef604345f02b447c5020e480']['description'] = 'Votre colis est disponible au bureau de poste. Le destinataire dispose de 15 jours consecutifs pour retirer le colis sur pr&eacute;sentation de son bon de retrait et d\'une pi&egrave;ce d\'identit&eacute;.';
$status['212a4af0ef604345f02b447c5020e480e']['notification_client'] = 0;
$status['212a4af0ef604345f02b447c5020e480']['notification_email_template'] = 0;
$status['212a4af0ef604345f02b447c5020e480']['remboursable'] = 'true';
$status['212a4af0ef604345f02b447c5020e480']['initial_transit'] = 'false';

$status['53461181506cc299d64056c4cd7b943f']['description'] = 'Votre colis est livr&eacute; au gardien ou a un des voisins.';
$status['53461181506cc299d64056c4cd7b943f']['notification_client'] = 0;
$status['53461181506cc299d64056c4cd7b943f']['notification_email_template'] = 0;
$status['53461181506cc299d64056c4cd7b943f']['remboursable'] = 'true';
$status['53461181506cc299d64056c4cd7b943f']['initial_transit'] = 'false'; 

// 14 avril 2010
$status['08171c63d0fb021de2a1974d905faecc']['description'] = 'Votre colis est arriv&eacute; sur son site de distribution.';
$status['08171c63d0fb021de2a1974d905faecc']['notification_client'] = 0;
$status['08171c63d0fb021de2a1974d905faecc']['notification_email_template'] = 0;
$status['08171c63d0fb021de2a1974d905faecc']['remboursable'] = 'true';
$status['08171c63d0fb021de2a1974d905faecc']['initial_transit'] = 'true';

$status['2870794edff959852766f04b72aef34b']['description'] = 'Votre colis est pr&ecirc;t &agrave; &ecirc;tre livr&eacute;.';
$status['2870794edff959852766f04b72aef34b']['notification_client'] = 0;
$status['2870794edff959852766f04b72aef34b']['notification_email_template'] = 0;
$status['2870794edff959852766f04b72aef34b']['remboursable'] = 'true';
$status['2870794edff959852766f04b72aef34b']['initial_transit'] = 'true';

$status['c3074f3aa79f84853759c57280c654bf']['description'] = 'Votre colis est &agrave; disposition en bo&icirc;te postale.';
$status['c3074f3aa79f84853759c57280c654bf']['notification_client'] = 0;
$status['c3074f3aa79f84853759c57280c654bf']['notification_email_template'] = 0;
$status['c3074f3aa79f84853759c57280c654bf']['remboursable'] = 'true';
$status['c3074f3aa79f84853759c57280c654bf']['initial_transit'] = 'true'; 

// 20 avril 2010
$status['130dc4477afc212a9f956c1579e23e2e']['description'] = 'Colis livr&eacute;';
$status['130dc4477afc212a9f956c1579e23e2e']['notification_client'] = 0;
$status['130dc4477afc212a9f956c1579e23e2e']['notification_email_template'] = 0;
$status['130dc4477afc212a9f956c1579e23e2e']['remboursable'] = 'true';
$status['130dc4477afc212a9f956c1579e23e2e']['initial_transit'] = 'false';

$status['4f2d82485245f3db51d14143e875ae6b']['description'] = 'Colis pris en charge dans le r&eacute;seau';
$status['4f2d82485245f3db51d14143e875ae6b']['notification_client'] = 0;
$status['4f2d82485245f3db51d14143e875ae6b']['notification_email_template'] = 0;
$status['4f2d82485245f3db51d14143e875ae6b']['remboursable'] = 'true';
$status['4f2d82485245f3db51d14143e875ae6b']['initial_transit'] = 'true';

// 02 juin 2010
$status['662d390411b8c94b813857bbe46ca696']['description'] = 'Votre colis est pr&ecirc;t &agrave; &ecirc;tre exp&eacute;di&eacute;. Il n\'est pas encore pris en charge par La Poste.';
$status['662d390411b8c94b813857bbe46ca696']['notification_client'] = 0;
$status['662d390411b8c94b813857bbe46ca696']['notification_email_template'] = 0;
$status['662d390411b8c94b813857bbe46ca696']['remboursable'] = 'true';
$status['662d390411b8c94b813857bbe46ca696']['initial_transit'] = 'true';

$status['141bf2d550d073329c332da9ab805816']['description'] = 'Votre colis est pr&ecirc;t &agrave; &ecirc;tre exp&eacute;di&eacute;. Il n\'est pas encore pris en charge par La Poste.';
$status['141bf2d550d073329c332da9ab805816']['notification_client'] = 0;
$status['141bf2d550d073329c332da9ab805816']['notification_email_template'] = 0;
$status['141bf2d550d073329c332da9ab805816']['remboursable'] = 'true';
$status['141bf2d550d073329c332da9ab805816']['initial_transit'] = 'true';

$status['f00beef2c0fdbfd354ae622f2b555b1b']['description'] = 'Votre colis est pr&ecirc;t &agrave; &ecirc;tre exp&eacute;di&eacute;. Il n\'est pas encore pris en charge par La Poste.';
$status['f00beef2c0fdbfd354ae622f2b555b1b']['notification_client'] = 0;
$status['f00beef2c0fdbfd354ae622f2b555b1b']['notification_email_template'] = 0;
$status['f00beef2c0fdbfd354ae622f2b555b1b']['remboursable'] = 'true';
$status['f00beef2c0fdbfd354ae622f2b555b1b']['initial_transit'] = 'true';

$status['6db6d5691e50dddfc752bc072766f414']['description'] = 'Colis livr&eacute;';
$status['6db6d5691e50dddfc752bc072766f414']['notification_client'] = 0;
$status['6db6d5691e50dddfc752bc072766f414']['notification_email_template'] = 0;
$status['6db6d5691e50dddfc752bc072766f414']['remboursable'] = 'true';
$status['6db6d5691e50dddfc752bc072766f414']['initial_transit'] = 'false';

$status['25ad5b7a6511fba97b00e514b8cb770a']['description'] = 'Votre colis est pris en charge par laposte. Il est en cours d\'acheminement';
$status['25ad5b7a6511fba97b00e514b8cb770a']['notification_client'] = 0;
$status['25ad5b7a6511fba97b00e514b8cb770a']['notification_email_template'] = 0;
$status['25ad5b7a6511fba97b00e514b8cb770a']['remboursable'] = 'true';
$status['25ad5b7a6511fba97b00e514b8cb770a']['initial_transit'] = 'true';

$status['e61cd96b5a3ed2289eabfbe7d458f5a0']['description'] = 'Votre colis est livr&eacute; au gardien ou &agrave; un des voisins.';
$status['e61cd96b5a3ed2289eabfbe7d458f5a0']['notification_client'] = 0;
$status['e61cd96b5a3ed2289eabfbe7d458f5a0']['notification_email_template'] = 0;
$status['e61cd96b5a3ed2289eabfbe7d458f5a0']['remboursable'] = 'true';
$status['e61cd96b5a3ed2289eabfbe7d458f5a0']['initial_transit'] = 'false';

$status['1cc984f62d70fd3e3ab995851723c513']['description'] = 'Votre colis est disponible au bureau de poste. Le destinataire, une fois l\'avis d\'instance re&ccedil;u, dispose de 15 jours consecutifs pour retirer le colis sur pr&eacute;sentation de son bon de retrait et d\'une pi&egrave;ce d\'identit&eacute;.';
$status['1cc984f62d70fd3e3ab995851723c513']['notification_client'] = 0;
$status['1cc984f62d70fd3e3ab995851723c513']['notification_email_template'] = 0;
$status['1cc984f62d70fd3e3ab995851723c513']['remboursable'] = 'true';
$status['1cc984f62d70fd3e3ab995851723c513']['initial_transit'] = 'false';

$status['4d7431da7ae9baf6c804cef59333e274']['description'] = 'Votre colis est disponible au bureau de poste. Le destinataire, une fois l\'avis d\'instance re&ccedil;u, dispose de 15 jours consecutifs pour retirer le colis sur pr&eacute;sentation de son bon de retrait et d\'une pi&egrave;ce d\'identit&eacute;.';
$status['4d7431da7ae9baf6c804cef59333e274']['notification_client'] = 0;
$status['4d7431da7ae9baf6c804cef59333e274']['notification_email_template'] = 0;
$status['4d7431da7ae9baf6c804cef59333e274']['remboursable'] = 'true';
$status['4d7431da7ae9baf6c804cef59333e274']['initial_transit'] = 'false';

$status['c364a15c34d27b8b2c2c70128bacddda']['description'] = 'Votre colis est disponible au bureau de poste. Le destinataire, une fois l\'avis d\'instance re&ccedil;u, dispose de 10 jours consecutifs pour retirer le colis sur pr&eacute;sentation de son bon de retrait et d\'une pi&egrave;ce d\'identit&eacute;.';
$status['c364a15c34d27b8b2c2c70128bacddda']['notification_client'] = 0;
$status['c364a15c34d27b8b2c2c70128bacddda']['notification_email_template'] = 0;
$status['c364a15c34d27b8b2c2c70128bacddda']['remboursable'] = 'true';
$status['c364a15c34d27b8b2c2c70128bacddda']['initial_transit'] = 'false';

$status['8c87ec27d85bda245b2665a790d832be']['description'] = 'Votre colis est arriv&eacute; sur son site de distribution';
$status['8c87ec27d85bda245b2665a790d832be']['notification_client'] = 0;
$status['8c87ec27d85bda245b2665a790d832be']['notification_email_template'] = 0;
$status['8c87ec27d85bda245b2665a790d832be']['remboursable'] = 'true';
$status['8c87ec27d85bda245b2665a790d832be']['initial_transit'] = 'true';

$status['0a64722e2d9f1c0a6fa611da91d951a0']['description'] = 'Votre colis est arriv&eacute; dans le pays de destination.';
$status['0a64722e2d9f1c0a6fa611da91d951a0']['notification_client'] = 0;
$status['0a64722e2d9f1c0a6fa611da91d951a0']['notification_email_template'] = 0;
$status['0a64722e2d9f1c0a6fa611da91d951a0']['remboursable'] = 'false';
$status['0a64722e2d9f1c0a6fa611da91d951a0']['initial_transit'] = 'true';

$status['e4ecccd056a93d33ec845cdd89c163a4']['description'] = 'Votre colis est &agrave; disposition en boite postale.';
$status['e4ecccd056a93d33ec845cdd89c163a4']['notification_client'] = 0;
$status['e4ecccd056a93d33ec845cdd89c163a4']['notification_email_template'] = 0;
$status['e4ecccd056a93d33ec845cdd89c163a4']['remboursable'] = 'true';
$status['e4ecccd056a93d33ec845cdd89c163a4']['initial_transit'] = 'false';

$status['ac086103404ff820adf0a23709cfb8bd']['description'] = 'Votre colis s\'apprête &agrave; sortir du pays d\'origine.';
$status['ac086103404ff820adf0a23709cfb8bd']['notification_client'] = 0;
$status['ac086103404ff820adf0a23709cfb8bd']['notification_email_template'] = 0;
$status['ac086103404ff820adf0a23709cfb8bd']['remboursable'] = 'false';
$status['ac086103404ff820adf0a23709cfb8bd']['initial_transit'] = 'true';

$status['7521014ef3f418ef4364d57da3c71b81']['description'] = 'La livraison de votre colis a &eacute;t&eacute; report&eacute;e pour absence du destinataire ou cas de force majeur.';
$status['7521014ef3f418ef4364d57da3c71b81']['notification_client'] = 0;
$status['7521014ef3f418ef4364d57da3c71b81']['notification_email_template'] = 0;
$status['7521014ef3f418ef4364d57da3c71b81']['remboursable'] = 'true';
$status['7521014ef3f418ef4364d57da3c71b81']['initial_transit'] = 'true';

$status['9ac0f6da590b74ff569a497ead419c6a']['description'] = 'Le destinataire &eacute;tait absent lors de la livraison. Votre colis sera present&eacute; une nouvelle fois le prochain jour ouvr&eacute;';
$status['9ac0f6da590b74ff569a497ead419c6a']['notification_client'] = 0;
$status['9ac0f6da590b74ff569a497ead419c6a']['notification_email_template'] = 0;
$status['9ac0f6da590b74ff569a497ead419c6a']['remboursable'] = 'true';
$status['9ac0f6da590b74ff569a497ead419c6a']['initial_transit'] = 'false';

$status['c34e99e02f771fcc6da158a6d1b2646d']['description'] = 'Colis livr&eacute;';
$status['c34e99e02f771fcc6da158a6d1b2646d']['notification_client'] = 0;
$status['c34e99e02f771fcc6da158a6d1b2646d']['notification_email_template'] = 0;
$status['c34e99e02f771fcc6da158a6d1b2646d']['remboursable'] = 'true';
$status['c34e99e02f771fcc6da158a6d1b2646d']['initial_transit'] = 'false';

// 03 juin 2010
$status['64f436ca350f7aab5f12fdb702199c60']['description'] = 'Votre colis est pris en charge par La Poste. Il est en cours d\'acheminement.';
$status['64f436ca350f7aab5f12fdb702199c60']['notification_client'] = 0;
$status['64f436ca350f7aab5f12fdb702199c60']['notification_email_template'] = 0;
$status['64f436ca350f7aab5f12fdb702199c60']['remboursable'] = 'true';
$status['64f436ca350f7aab5f12fdb702199c60']['initial_transit'] = 'true';

// 04 juin 2010
$status['a886d1ab3721106c85934986e28d82c4']['description'] = 'Votre colis est en attente de distribution et sera livr&eacute; prochainement.';
$status['a886d1ab3721106c85934986e28d82c4']['notification_client'] = 0;
$status['a886d1ab3721106c85934986e28d82c4']['notification_email_template'] = 0;
$status['a886d1ab3721106c85934986e28d82c4']['remboursable'] = 'true';
$status['a886d1ab3721106c85934986e28d82c4']['initial_transit'] = 'true';

$status['ef222c3eeaccac94bb71113599128112']['description'] = 'Votre coli est pr&egrave;t &agrave; &ecirc;tre livr&eacute;.';
$status['ef222c3eeaccac94bb71113599128112']['notification_client'] = 0;
$status['ef222c3eeaccac94bb71113599128112']['notification_email_template'] = 0;
$status['ef222c3eeaccac94bb71113599128112']['remboursable'] = 'true';
$status['ef222c3eeaccac94bb71113599128112']['initial_transit'] = 'true';

$status['8fb4d33f32c97580464d7a41f50fec54']['description'] = 'Votre colis est pris en charge par La Poste. Il est en cours d\'acheminement.';
$status['8fb4d33f32c97580464d7a41f50fec54']['notification_client'] = 0;
$status['8fb4d33f32c97580464d7a41f50fec54']['notification_email_template'] = 0;
$status['8fb4d33f32c97580464d7a41f50fec54']['remboursable'] = 'true';
$status['8fb4d33f32c97580464d7a41f50fec54']['initial_transit'] = 'true';

$status['2be4ab33279da44036e6de4f35e20961']['description'] = 'Votre colis est disponible au bureau de poste. Votre destinataire, une fois l\'avis d\'instance re&ccedil;u, dispose de 10 jours ouvr&eacute;s pour venir retirer le colis sur pr&eacute;sentation d\'une pi&egrave;ce d\'identit&eacute;.';
$status['2be4ab33279da44036e6de4f35e20961']['notification_client'] = 0;
$status['2be4ab33279da44036e6de4f35e20961']['notification_email_template'] = 0;
$status['2be4ab33279da44036e6de4f35e20961']['remboursable'] = 'true';
$status['2be4ab33279da44036e6de4f35e20961']['initial_transit'] = 'false';

$status['b20035184b4f77598ee44c3348ecaf8e']['description'] = 'Votre colis est arriv&eacute; sur son site de distribution';
$status['b20035184b4f77598ee44c3348ecaf8e']['notification_client'] = 0;
$status['b20035184b4f77598ee44c3348ecaf8e']['notification_email_template'] = 0;
$status['b20035184b4f77598ee44c3348ecaf8e']['remboursable'] = 'true';
$status['b20035184b4f77598ee44c3348ecaf8e']['initial_transit'] = 'true';

// 05 juin 2010
$status['662d390411b8c94b813857bbe46ca696']['description'] = 'Votre colis est pr&ecirc;t &agrave; &ecirc;tre exp&eacute;di&eacute;. Il n\'est pas encore pris en charge par La Poste.';
$status['662d390411b8c94b813857bbe46ca696']['notification_client'] = 0;
$status['662d390411b8c94b813857bbe46ca696']['notification_email_template'] = 0;
$status['662d390411b8c94b813857bbe46ca696']['remboursable'] = 'true';
$status['662d390411b8c94b813857bbe46ca696']['initial_transit'] = 'tue';

$status['8fb4d33f32c97580464d7a41f50fec54']['description'] = 'Votre colis est pris en charge par laposte. Il est en cours d\'acheminement';
$status['8fb4d33f32c97580464d7a41f50fec54']['notification_client'] = 0;
$status['8fb4d33f32c97580464d7a41f50fec54']['notification_email_template'] = 0;
$status['8fb4d33f32c97580464d7a41f50fec54']['remboursable'] = 'true';
$status['8fb4d33f32c97580464d7a41f50fec54']['initial_transit'] = 'true';

// 08 juin 2010
$status['8c87ec27d85bda245b2665a790d832be']['description'] = 'Votre colis est livr&eacute; au gardien ou &agrave; un des voisins.';
$status['8c87ec27d85bda245b2665a790d832be']['notification_client'] = 0;
$status['8c87ec27d85bda245b2665a790d832be']['notification_email_template'] = 0;
$status['8c87ec27d85bda245b2665a790d832be']['remboursable'] = 'true';
$status['8c87ec27d85bda245b2665a790d832be']['initial_transit'] = 'false';

$status['fd8d6ce7ed7af2b1c343f9eb633b526d']['description'] = 'Votre colis est arriv&eacute; par erreur sur un site. Il est en cours de r&eacute;acheminement vers son site de distribution.';
$status['fd8d6ce7ed7af2b1c343f9eb633b526d']['notification_client'] = 0;
$status['fd8d6ce7ed7af2b1c343f9eb633b526d']['notification_email_template'] = 0;
$status['fd8d6ce7ed7af2b1c343f9eb633b526d']['remboursable'] = 'true';
$status['fd8d6ce7ed7af2b1c343f9eb633b526d']['initial_transit'] = 'true';

$status['b5beef7a53c647e996c04da8d40ca303']['description'] = 'Le destinataire du colis n\'habite pas &agrave; l\'adresse indiqu&eacute;e. Le colis est retourn&eacute; &agrave; l\'exp&eacute;diteur. ';
$status['b5beef7a53c647e996c04da8d40ca303']['notification_client'] = 0;
$status['b5beef7a53c647e996c04da8d40ca303']['notification_email_template'] = 0;
$status['b5beef7a53c647e996c04da8d40ca303']['remboursable'] = 'false';
$status['b5beef7a53c647e996c04da8d40ca303']['initial_transit'] = 'false';

// 09 juin 2010
$status['44134c9ababf7da385ba00d4cad50a6c']['description'] = 'Votre colis est arriv&eacute; sur son site de distribution';
$status['44134c9ababf7da385ba00d4cad50a6c']['notification_client'] = 0;
$status['44134c9ababf7da385ba00d4cad50a6c']['notification_email_template'] = 0;
$status['44134c9ababf7da385ba00d4cad50a6c']['remboursable'] = 'true';
$status['44134c9ababf7da385ba00d4cad50a6c']['initial_transit'] = 'true';

// 10 juin 2010
$status['3c5b6c324b869f915685fb9b75c83aee']['description'] = 'L\'adresse de votre colis est incompl&egrave;te. Nous recherchons la partie non renseign&eacute;e pour le livrer.';
$status['3c5b6c324b869f915685fb9b75c83aee']['notification_client'] = 0;
$status['3c5b6c324b869f915685fb9b75c83aee']['notification_email_template'] = 0;
$status['3c5b6c324b869f915685fb9b75c83aee']['remboursable'] = 'true';
$status['3c5b6c324b869f915685fb9b75c83aee']['initial_transit'] = 'true';

// 11 juin 2010
$status['221506256f93578778fd2790217d6eb1']['description'] = 'Votre colis a &eacute;t&eacute; d&eacute;pos&eacute; au bureau de poste d\'exp&eacute;dition.';
$status['221506256f93578778fd2790217d6eb1']['notification_client'] = 0;
$status['221506256f93578778fd2790217d6eb1']['notification_email_template'] = 0;
$status['221506256f93578778fd2790217d6eb1']['remboursable'] = 'true';
$status['221506256f93578778fd2790217d6eb1']['initial_transit'] = 'true';

$status['14675dc0f4026e9facd78b6b57d6f2af']['description'] = 'Colis livr&eacute;';
$status['14675dc0f4026e9facd78b6b57d6f2af']['notification_client'] = 0;
$status['14675dc0f4026e9facd78b6b57d6f2af']['notification_email_template'] = 0;
$status['14675dc0f4026e9facd78b6b57d6f2af']['remboursable'] = 'true';
$status['14675dc0f4026e9facd78b6b57d6f2af']['initial_transit'] = 'false';

$status['ed505271a1046ff78d0e319edda13fa9']['description'] = 'Votre colis est livr&eacute; au gardien ou &agrave; un des voisins.';
$status['ed505271a1046ff78d0e319edda13fa9']['notification_client'] = 0;
$status['ed505271a1046ff78d0e319edda13fa9']['notification_email_template'] = 0;
$status['ed505271a1046ff78d0e319edda13fa9']['remboursable'] = 'true';
$status['ed505271a1046ff78d0e319edda13fa9']['initial_transit'] = 'false';

$status['8c44d4754a50d2a7253aa13aa4385941']['description'] = 'L\'adresse de votre colis est incompl&egrave;te. Nous recherchons la partie non renseign&eacute;e pour le livrer.';
$status['8c44d4754a50d2a7253aa13aa4385941']['notification_client'] = 0;
$status['8c44d4754a50d2a7253aa13aa4385941']['notification_email_template'] = 0;
$status['8c44d4754a50d2a7253aa13aa4385941']['remboursable'] = 'true';
$status['8c44d4754a50d2a7253aa13aa4385941']['initial_transit'] = 'true';

$status['857a8dcc519009dc0522355d64603213']['description'] = 'Le destinataire &eacute;tait absent lors de la livraison. Votre colis sera present&eacute; une nouvelle fois le prochain jour ouvr&eacute;';
$status['857a8dcc519009dc0522355d64603213']['notification_client'] = 0;
$status['857a8dcc519009dc0522355d64603213']['notification_email_template'] = 0;
$status['857a8dcc519009dc0522355d64603213']['remboursable'] = 'true';
$status['857a8dcc519009dc0522355d64603213']['initial_transit'] = 'false';

// 15 juin 2010
$status['890a3c56ace97e4edcd82db2ec63520c']['description'] = 'Le colis n\'a pu &ecirc;tre livr&eacute;, il est retourn&eacute; &agrave; l\'exp&eacute;diteur.';
$status['890a3c56ace97e4edcd82db2ec63520c']['notification_client'] = 0;
$status['890a3c56ace97e4edcd82db2ec63520c']['notification_email_template'] = 0;
$status['890a3c56ace97e4edcd82db2ec63520c']['remboursable'] = 'true';
$status['890a3c56ace97e4edcd82db2ec63520c']['initial_transit'] = 'false';

// 22 juin 2010
$status['4cfa37aaf199f9042bf25d6b93e552cd']['description'] = 'Votre colis est livré.';
$status['4cfa37aaf199f9042bf25d6b93e552cd']['notification_client'] = 0;
$status['4cfa37aaf199f9042bf25d6b93e552cd']['notification_email_template'] = 0;
$status['4cfa37aaf199f9042bf25d6b93e552cd']['remboursable'] = 'true';
$status['4cfa37aaf199f9042bf25d6b93e552cd']['initial_transit'] = 'false';

$status['3a03c12f19f8773e895175a14cc630f5']['description'] = 'Votre colis est disponible au bureau de poste. Le destinataire dispose de 15 jours consécutifs pour retirer le colis sur présentation d\'une pièce d\'identité.';
$status['3a03c12f19f8773e895175a14cc630f5']['notification_client'] = 0;
$status['3a03c12f19f8773e895175a14cc630f5']['notification_email_template'] = 0;
$status['3a03c12f19f8773e895175a14cc630f5']['remboursable'] = 'true';
$status['3a03c12f19f8773e895175a14cc630f5']['initial_transit'] = 'false';

$status['112cfe28fc8858725f27fe46158dfb02']['description'] = 'Votre colis est pris en charge par La Poste. Il est en cours d\'acheminement.';
$status['112cfe28fc8858725f27fe46158dfb02']['notification_client'] = 0;
$status['112cfe28fc8858725f27fe46158dfb02']['notification_email_template'] = 0;
$status['112cfe28fc8858725f27fe46158dfb02']['remboursable'] = 'true';
$status['112cfe28fc8858725f27fe46158dfb02']['initial_transit'] = 'true';

$status['7442edf8f72a400ae36f711d13a86345']['description'] = 'La livraison de votre colis à été reportée pour absence du destinataire ou cas de force majeure.';
$status['7442edf8f72a400ae36f711d13a86345']['notification_client'] = 0;
$status['7442edf8f72a400ae36f711d13a86345']['notification_email_template'] = 0;
$status['7442edf8f72a400ae36f711d13a86345']['remboursable'] = 'true';
$status['7442edf8f72a400ae36f711d13a86345']['initial_transit'] = 'false';

$status['e2b4de87cca20b4bf159889ab8f67e0a']['description'] = 'Votre colis est livré au gardien ou a un des voisins.';
$status['e2b4de87cca20b4bf159889ab8f67e0a']['notification_client'] = 0;
$status['e2b4de87cca20b4bf159889ab8f67e0a']['notification_email_template'] = 0;
$status['e2b4de87cca20b4bf159889ab8f67e0a']['remboursable'] = 'true';
$status['e2b4de87cca20b4bf159889ab8f67e0a']['initial_transit'] = 'false'; 

$status['946aef69263d0321e4048b3a6dcc98db']['description'] = 'Votre colis est disponible au bureau de poste. Le destinataire une fois l\'avis d\'instance reçu, dispose de 15 jours consécutifs pour retirer le colis sur présentation d\'une pièce d\'identité.';
$status['946aef69263d0321e4048b3a6dcc98db']['notification_client'] = 0;
$status['946aef69263d0321e4048b3a6dcc98db']['notification_email_template'] = 0;
$status['946aef69263d0321e4048b3a6dcc98db']['remboursable'] = 'true';
$status['946aef69263d0321e4048b3a6dcc98db']['initial_transit'] = 'false';

// 23 juin 2010
$status['b5e61297bffa733e09182a151925a6fc']['description'] = 'Votre colis a été déposé au bureau de poste d\'expédition.';
$status['b5e61297bffa733e09182a151925a6fc']['notification_client'] = 0;
$status['b5e61297bffa733e09182a151925a6fc']['notification_email_template'] = 0;
$status['b5e61297bffa733e09182a151925a6fc']['remboursable'] = 'true';
$status['b5e61297bffa733e09182a151925a6fc']['initial_transit'] = 'true';

$status['d558d783132e24025d742749383f8474']['description'] = 'Votre colis est arriv&eacute; sur son site de distribution';
$status['d558d783132e24025d742749383f8474']['notification_client'] = 0;
$status['d558d783132e24025d742749383f8474']['notification_email_template'] = 0;
$status['d558d783132e24025d742749383f8474']['remboursable'] = 'true';
$status['d558d783132e24025d742749383f8474']['initial_transit'] = 'true';

$status['74f1ad4e177983eeee2d6a0db21597dc']['description'] = 'Le destinataire &eacute;tait absent lors de la premi&egrave;re livraison. Votre colis sera present&eacute; une nouvelle fois le prochain jour ouvr&eacute;';
$status['74f1ad4e177983eeee2d6a0db21597dc']['notification_client'] = 0;
$status['74f1ad4e177983eeee2d6a0db21597dc']['notification_email_template'] = 0;
$status['74f1ad4e177983eeee2d6a0db21597dc']['remboursable'] = 'true';
$status['74f1ad4e177983eeee2d6a0db21597dc']['initial_transit'] = 'false';

$status['45dfedae324d524650cdd722497ccc9e']['description'] = 'L\'adresse de votre colis est incomplète, nous recherchons la partie non renseignée pour le livrer.';
$status['45dfedae324d524650cdd722497ccc9e']['notification_client'] = 0;
$status['45dfedae324d524650cdd722497ccc9e']['notification_email_template'] = 0;
$status['45dfedae324d524650cdd722497ccc9e']['remboursable'] = 'false';
$status['45dfedae324d524650cdd722497ccc9e']['initial_transit'] = 'false';

// 30 juin 2010
$status['0495af3c561613a4051af7abbb7c0b0f']['description'] = 'Votre colis est en attente de distribution et sera livr&eacute; prochainement.';
$status['0495af3c561613a4051af7abbb7c0b0f']['notification_client'] = 0;
$status['0495af3c561613a4051af7abbb7c0b0f']['notification_email_template'] = 0;
$status['0495af3c561613a4051af7abbb7c0b0f']['remboursable'] = 'true';
$status['0495af3c561613a4051af7abbb7c0b0f']['initial_transit'] = 'true';

$status['ef018b7e4ba178894e472b5f465ed1d8']['description'] = 'Le colis est r&eacute;exp&eacute;di&eacute; &agrave; la demande du destinataire, 
vers l\'adresse de son choix.';
$status['ef018b7e4ba178894e472b5f465ed1d8']['notification_client'] = 0;
$status['ef018b7e4ba178894e472b5f465ed1d8']['notification_email_template'] = 0;
$status['ef018b7e4ba178894e472b5f465ed1d8']['remboursable'] = 'true';
$status['ef018b7e4ba178894e472b5f465ed1d8']['initial_transit'] = 'true';

// 3 juillet 2010
$status['88040d20a58a8f03e883c246eeaced22']['description'] = 'Votre colis est arriv&eacute; dans le pays de destination.';
$status['88040d20a58a8f03e883c246eeaced22']['notification_client'] = 0;
$status['88040d20a58a8f03e883c246eeaced22']['notification_email_template'] = 0;
$status['88040d20a58a8f03e883c246eeaced22']['remboursable'] = 'false';
$status['88040d20a58a8f03e883c246eeaced22']['initial_transit'] = 'true';

// 10 juillet 2010
$status['a3639cbbf87991871c78c8e7dd281ad0']['description'] = 'L\'emballage de votre colis a été renforcé pour assurer sa livraison';
$status['a3639cbbf87991871c78c8e7dd281ad0']['notification_client'] = 0;
$status['a3639cbbf87991871c78c8e7dd281ad0']['notification_email_template'] = 0;
$status['a3639cbbf87991871c78c8e7dd281ad0']['remboursable'] = 'true';
$status['a3639cbbf87991871c78c8e7dd281ad0']['initial_transit'] = 'true';






// 03 février 2012
$status['cec7598c561fac54650b55f56f2d4df2']['description'] = 'Votre colis a été remis à un voisin.';
$status['cec7598c561fac54650b55f56f2d4df2']['notification_client'] = 0;
$status['cec7598c561fac54650b55f56f2d4df2']['notification_email_template'] = 0;
$status['cec7598c561fac54650b55f56f2d4df2']['remboursable'] = 'true';
$status['cec7598c561fac54650b55f56f2d4df2']['initial_transit'] = 'false';

//31 mars 2012
$status['a9077766ce3feb09cdbc2b0c5f7486d9']['description'] = 'Votre colis est en cours de livraison dans le point retrait "la poste" sélectionné.';
$status['a9077766ce3feb09cdbc2b0c5f7486d9']['notification_client'] = 0;
$status['a9077766ce3feb09cdbc2b0c5f7486d9']['notification_email_template'] = 0;
$status['a9077766ce3feb09cdbc2b0c5f7486d9']['remboursable'] = 'true';
$status['a9077766ce3feb09cdbc2b0c5f7486d9']['initial_transit'] = 'true';

//24 avril 2012
$status['083fbd923969fa4ba015c8f99b46859f']['description'] = 'Votre colis a &eacute;t&eacute; remis au gardien.';
$status['083fbd923969fa4ba015c8f99b46859f']['notification_client'] = 0;
$status['083fbd923969fa4ba015c8f99b46859f']['notification_email_template'] = 0;
$status['083fbd923969fa4ba015c8f99b46859f']['remboursable'] = 'true';
$status['083fbd923969fa4ba015c8f99b46859f']['initial_transit'] = 'false';

//24 avril 2012
$status['32576b8e34a2c432025723f7593b16f8']['description'] = 'Votre colis est en cours de livraison dans le bureau de poste du destinataire.';
$status['32576b8e34a2c432025723f7593b16f8']['notification_client'] = 0;
$status['32576b8e34a2c432025723f7593b16f8']['notification_email_template'] = 0;
$status['32576b8e34a2c432025723f7593b16f8']['remboursable'] = 'true';
$status['32576b8e34a2c432025723f7593b16f8']['initial_transit'] = 'true';

//10 mai 2012
$status['d4f8ac7aff515c2f904a13eb5e1fea70']['description'] = 'Votre colis est disponible dans votre bureau de poste. Le destinataire dispose de 15 jours consécutifs pour retirer son colis sur présentation d\'une pièce d\'identité et de l\'avis d\'instance.';
$status['d4f8ac7aff515c2f904a13eb5e1fea70']['notification_client'] = 0;
$status['d4f8ac7aff515c2f904a13eb5e1fea70']['notification_email_template'] = 0;
$status['d4f8ac7aff515c2f904a13eb5e1fea70']['remboursable'] = 'true';
$status['d4f8ac7aff515c2f904a13eb5e1fea70']['initial_transit'] = 'true';


//------------------- 27 07 2012

$status['3e6b38690aa156d617bf44e96d4d670c']['description'] = 'Colis livr&eacute;';
$status['3e6b38690aa156d617bf44e96d4d670c']['notification_client'] = 1;
$status['3e6b38690aa156d617bf44e96d4d670c']['notification_email_template'] = 1;
$status['3e6b38690aa156d617bf44e96d4d670c']['remboursable'] = 'true';
$status['3e6b38690aa156d617bf44e96d4d670c']['initial_transit'] = 'false';

$status['362193d9c30566bfadda91ec23201b4a']['description'] = 'Colis livr&eacute;';
$status['362193d9c30566bfadda91ec23201b4a']['notification_client'] = 1;
$status['362193d9c30566bfadda91ec23201b4a']['notification_email_template'] = 1;
$status['362193d9c30566bfadda91ec23201b4a']['remboursable'] = 'true';
$status['362193d9c30566bfadda91ec23201b4a']['initial_transit'] = 'false';

$status['dd51f8d94b57c7a47380d82a1e28ab6d']['description'] = 'Colis livr&eacute;';
$status['dd51f8d94b57c7a47380d82a1e28ab6d']['notification_client'] = 1;
$status['dd51f8d94b57c7a47380d82a1e28ab6d']['notification_email_template'] = 1;
$status['dd51f8d94b57c7a47380d82a1e28ab6d']['remboursable'] = 'true';
$status['dd51f8d94b57c7a47380d82a1e28ab6d']['initial_transit'] = 'false';


$status['2f25d555cf54c1a92c24b9aa8a30dd9f']['description'] = 'Votre colis est livr&eacute; au gardien ou &agrave; un des voisins.';
$status['2f25d555cf54c1a92c24b9aa8a30dd9f']['notification_client'] = 1;
$status['2f25d555cf54c1a92c24b9aa8a30dd9f']['notification_email_template'] = 1;
$status['2f25d555cf54c1a92c24b9aa8a30dd9f']['remboursable'] = 'true';
$status['2f25d555cf54c1a92c24b9aa8a30dd9f']['initial_transit'] = 'false';

$status['356a746095f1f5637e137269462bc913']['description'] = 'Votre colis est livr&eacute; au gardien ou &agrave; un des voisins.';
$status['356a746095f1f5637e137269462bc913']['notification_client'] = 1;
$status['356a746095f1f5637e137269462bc913']['notification_email_template'] = 1;
$status['356a746095f1f5637e137269462bc913']['remboursable'] = 'true';
$status['356a746095f1f5637e137269462bc913']['initial_transit'] = 'false';

$status['f48ced5f1822240b9bc41bfedf8ee522']['description'] = 'Votre colis est livr&eacute; au gardien ou &agrave; un des voisins.';
$status['f48ced5f1822240b9bc41bfedf8ee522']['notification_client'] = 1;
$status['f48ced5f1822240b9bc41bfedf8ee522']['notification_email_template'] = 1;
$status['f48ced5f1822240b9bc41bfedf8ee522']['remboursable'] = 'true';
$status['f48ced5f1822240b9bc41bfedf8ee522']['initial_transit'] = 'false';

$status['a0dd16b4f423453c794c30fdc7a6ee94']['description'] = 'Votre colis a ete remis &agrave; un voisin.';
$status['a0dd16b4f423453c794c30fdc7a6ee94']['notification_client'] = 1;
$status['a0dd16b4f423453c794c30fdc7a6ee94']['notification_email_template'] = 1;
$status['a0dd16b4f423453c794c30fdc7a6ee94']['remboursable'] = 'true';
$status['a0dd16b4f423453c794c30fdc7a6ee94']['initial_transit'] = 'false';

$status['5555775041b0786a2b94cabaa944d409']['description'] = 'Votre colis est pris en charge par La Poste. Il est en cours d\'acheminement.';
$status['5555775041b0786a2b94cabaa944d409']['notification_client'] = 1;
$status['5555775041b0786a2b94cabaa944d409']['notification_email_template'] = 1;
$status['5555775041b0786a2b94cabaa944d409']['remboursable'] = 'true';
$status['5555775041b0786a2b94cabaa944d409']['initial_transit'] = 'true';

$status['a3c53552091f7615eab4eb0c12ec6e3d']['description'] = 'Votre colis est pris en charge par La Poste. Il est en cours d\'acheminement.';
$status['a3c53552091f7615eab4eb0c12ec6e3d']['notification_client'] = 1;
$status['a3c53552091f7615eab4eb0c12ec6e3d']['notification_email_template'] = 1;
$status['a3c53552091f7615eab4eb0c12ec6e3d']['remboursable'] = 'true';
$status['a3c53552091f7615eab4eb0c12ec6e3d']['initial_transit'] = 'true';

$status['56d6befebe256653b9f79855288a3f6e']['description'] = 'Votre colis est pris en charge par La Poste. Il est en cours d\'acheminement.';
$status['56d6befebe256653b9f79855288a3f6e']['notification_client'] = 1;
$status['56d6befebe256653b9f79855288a3f6e']['notification_email_template'] = 1;

$status['56d6befebe256653b9f79855288a3f6e']['remboursable'] = 'true';
$status['56d6befebe256653b9f79855288a3f6e']['initial_transit'] = 'true';

$status['70a7ef5b3c3205f97f1656d06cb56bb5']['description'] = 'Votre colis est arriv&eacute; sur son site de distribution';
$status['70a7ef5b3c3205f97f1656d06cb56bb5']['notification_client'] = 1;
$status['70a7ef5b3c3205f97f1656d06cb56bb5']['notification_email_template'] = 1;
$status['70a7ef5b3c3205f97f1656d06cb56bb5']['remboursable'] = 'true';
$status['70a7ef5b3c3205f97f1656d06cb56bb5']['initial_transit'] = 'true';

$status['7261cad49a6daa889b5cbf7a4d940ced']['description'] = 'Votre colis est en attente de distribution et sera livr&eacute; prochainement.';
$status['7261cad49a6daa889b5cbf7a4d940ced']['notification_client'] = 1;
$status['7261cad49a6daa889b5cbf7a4d940ced']['notification_email_template'] = 1;
$status['7261cad49a6daa889b5cbf7a4d940ced']['remboursable'] = 'true';
$status['7261cad49a6daa889b5cbf7a4d940ced']['initial_transit'] = 'true';

$status['b1e70c6401a5934f41f41c7fabdf1608']['description'] = 'Votre colis est pr&ecirc;t &agrave; &ecirc;tre livr&eacute;.';
$status['b1e70c6401a5934f41f41c7fabdf1608']['notification_client'] = 1;
$status['b1e70c6401a5934f41f41c7fabdf1608']['notification_email_template'] = 1;
$status['b1e70c6401a5934f41f41c7fabdf1608']['remboursable'] = 'true';
$status['b1e70c6401a5934f41f41c7fabdf1608']['initial_transit'] = 'true';

$status['4711f08bd25841171284f55974b4cf52']['description'] = 'votre colis est en cours de livraison dans le point de retrait LA POSTE selectionne';
$status['4711f08bd25841171284f55974b4cf52']['notification_client'] = 1;
$status['4711f08bd25841171284f55974b4cf52']['notification_email_template'] = 1;
$status['4711f08bd25841171284f55974b4cf52']['remboursable'] = 'true';
$status['4711f08bd25841171284f55974b4cf52']['initial_transit'] = 'true';

$status['c22ae0ba3d042d302c2c6f22555c0758']['description'] = 'Votre colis est en cours de livraison dans le bureau de poste du destinataire';
$status['c22ae0ba3d042d302c2c6f22555c0758']['notification_client'] = 1;
$status['c22ae0ba3d042d302c2c6f22555c0758']['notification_email_template'] = 1;
$status['c22ae0ba3d042d302c2c6f22555c0758']['remboursable'] = 'true';
$status['c22ae0ba3d042d302c2c6f22555c0758']['initial_transit'] = 'true';

$status['a8e708f60e4f73752652878ad6a5f637']['description'] = 'Votre colis est disponible au bureau de poste. Le destinataire, une fois l\'avis d\'instance re&ccedil;u, dispose de 15 jours consecutifs pour retirer le colis sur pr&eacute;sentation de son bon de retrait et d\'une pi&egrave;ce d\'identit&eacute;.';
$status['a8e708f60e4f73752652878ad6a5f637']['notification_client'] = 1;
$status['a8e708f60e4f73752652878ad6a5f637']['notification_email_template'] = 1;
$status['a8e708f60e4f73752652878ad6a5f637']['remboursable'] = 'true';
$status['a8e708f60e4f73752652878ad6a5f637']['initial_transit'] = 'false';

$status['01d379acec7eaa8223fafa37df47dbf8']['description'] = 'Votre colis est &agrave; disposition en boite postale';
$status['01d379acec7eaa8223fafa37df47dbf8']['notification_client'] = 1;
$status['01d379acec7eaa8223fafa37df47dbf8']['notification_email_template'] = 1;
$status['01d379acec7eaa8223fafa37df47dbf8']['remboursable'] = 'true';
$status['01d379acec7eaa8223fafa37df47dbf8']['initial_transit'] = 'false';

$status['ee86d76fe02262884b96c8598148ac49']['description'] = 'Votre colis s\'apprete a sortir du pays d\'origine.';
$status['ee86d76fe02262884b96c8598148ac49']['notification_client'] = 1;
$status['ee86d76fe02262884b96c8598148ac49']['notification_email_template'] = 1;
$status['ee86d76fe02262884b96c8598148ac49']['remboursable'] = 'false';
$status['ee86d76fe02262884b96c8598148ac49']['initial_transit'] = 'true';

$status['8246fc47c6b0059645712dee8b30ab27']['description'] = 'identification du contenu de votre colis en cours, il est retenu par nos services';
$status['8246fc47c6b0059645712dee8b30ab27']['notification_client'] = 1;
$status['8246fc47c6b0059645712dee8b30ab27']['notification_email_template'] = 1;
$status['8246fc47c6b0059645712dee8b30ab27']['remboursable'] = 'false';
$status['8246fc47c6b0059645712dee8b30ab27']['initial_transit'] = 'true';

$status['fc8b2ed1ee15f7cb8188d46d42f548ae']['description'] = 'La livraison de votre colis a &eacute;t&eacute; report&eacute;e pour absence du destinataire ou cas de force majeur.';
$status['fc8b2ed1ee15f7cb8188d46d42f548ae']['notification_client'] = 1;
$status['fc8b2ed1ee15f7cb8188d46d42f548ae']['notification_email_template'] = 1;
$status['fc8b2ed1ee15f7cb8188d46d42f548ae']['remboursable'] = 'true';
$status['fc8b2ed1ee15f7cb8188d46d42f548ae']['initial_transit'] = 'true';

$status['ecdad1eec81817b33635785263faaa27']['description'] = 'L\'adresse de votre colis est incompl&egrave;te. Nous recherchons la partie non renseign&eacute;e pour le livrer.';
$status['ecdad1eec81817b33635785263faaa27']['notification_client'] = 1;
$status['ecdad1eec81817b33635785263faaa27']['notification_email_template'] = 1;
$status['ecdad1eec81817b33635785263faaa27']['remboursable'] = 'true';
$status['ecdad1eec81817b33635785263faaa27']['initial_transit'] = 'true';

$status['8eb37b078fe0a3be582b80aa9c6ac907']['description'] = 'Le destinataire &eacute;tait absent lors de la livraison. Votre colis sera present&eacute; une nouvelle fois le prochain jour ouvr&eacute;';
$status['8eb37b078fe0a3be582b80aa9c6ac907']['notification_client'] = 1;
$status['8eb37b078fe0a3be582b80aa9c6ac907']['notification_email_template'] = 1;
$status['8eb37b078fe0a3be582b80aa9c6ac907']['remboursable'] = 'true';
$status['8eb37b078fe0a3be582b80aa9c6ac907']['initial_transit'] = 'false';


$status['c8cbea7ef1f9bffbbae6c8d0ae71ff4b']['description'] = 'L\'adresse de votre colis est incompl&egrave;te. Nous recherchons la partie non renseign&eacute;e pour le livrer.';
$status['c8cbea7ef1f9bffbbae6c8d0ae71ff4b']['notification_client'] = 1;
$status['c8cbea7ef1f9bffbbae6c8d0ae71ff4b']['notification_email_template'] = 1;
$status['c8cbea7ef1f9bffbbae6c8d0ae71ff4b']['remboursable'] = 'true';
$status['c8cbea7ef1f9bffbbae6c8d0ae71ff4b']['initial_transit'] = 'true';



//30 juillet 2012
$status['8bc9706ee4a85b5f78e1bd3e9f4bbbf2']['description'] = 'Votre colis a &eacute;t&eacute; d&eacute;pos&eacute; au bureau de poste d\'exp&eacute;dition.';
$status['8bc9706ee4a85b5f78e1bd3e9f4bbbf2']['notification_client'] = 0;
$status['8bc9706ee4a85b5f78e1bd3e9f4bbbf2']['notification_email_template'] = 0;
$status['8bc9706ee4a85b5f78e1bd3e9f4bbbf2']['remboursable'] = 'true';
$status['8bc9706ee4a85b5f78e1bd3e9f4bbbf2']['initial_transit'] = 'true';

$status['152f2907d90ed7bd952a0495cb15b5e0']['description'] = 'Votre colis a &eacute;t&eacute; d&eacute;pos&eacute; au bureau de poste d\'exp&eacute;dition.';
$status['152f2907d90ed7bd952a0495cb15b5e0']['notification_client'] = 0;
$status['152f2907d90ed7bd952a0495cb15b5e0']['notification_email_template'] = 0;
$status['152f2907d90ed7bd952a0495cb15b5e0']['remboursable'] = 'true';
$status['152f2907d90ed7bd952a0495cb15b5e0']['initial_transit'] = 'true';

//20 août 2012

$status['3e6b38690aa156d617bf44e96d4d670c']['description'] = 'Votre colis a &eacute;t&eacute; d&eacute;pos&eacute; au bureau de poste d\'exp&eacute;dition.';
$status['3e6b38690aa156d617bf44e96d4d670c']['notification_client'] = 1;
$status['3e6b38690aa156d617bf44e96d4d670c']['notification_email_template'] = 1;
$status['3e6b38690aa156d617bf44e96d4d670c']['remboursable'] = 'true';
$status['3e6b38690aa156d617bf44e96d4d670c']['initial_transit'] = 'false';

$status['a3c53552091f7615eab4eb0c12ec6e3d']['description'] = 'Votre colis est pris en charge par la poste, il est en cours d\'acheminement.';
$status['a3c53552091f7615eab4eb0c12ec6e3d']['notification_client'] = 0;
$status['a3c53552091f7615eab4eb0c12ec6e3d']['notification_email_template'] = 0;
$status['a3c53552091f7615eab4eb0c12ec6e3d']['remboursable'] = 'true';
$status['a3c53552091f7615eab4eb0c12ec6e3d']['initial_transit'] = 'true';

$status['56d6befebe256653b9f79855288a3f6e']['description'] = 'Votre colis est pris en charge par la poste, il est en cours d\'acheminement.';
$status['a3c53552091f7615eab4eb0c12ec6e3d']['notification_client'] = 0;
$status['a3c53552091f7615eab4eb0c12ec6e3d']['notification_email_template'] = 0;
$status['56d6befebe256653b9f79855288a3f6e']['remboursable'] = 'true';
$status['56d6befebe256653b9f79855288a3f6e']['initial_transit'] = 'true';

$status['b5e61297bffa733e09182a151925a6fc']['description'] = 'Votre colis a été déposé dans le bureau de poste du destinataire.';
$status['a3c53552091f7615eab4eb0c12ec6e3d']['notification_client'] = 0;
$status['a3c53552091f7615eab4eb0c12ec6e3d']['notification_email_template'] = 0;
$status['b5e61297bffa733e09182a151925a6fc']['remboursable'] = 'true';
$status['b5e61297bffa733e09182a151925a6fc']['initial_transit'] = 'false';


$status['c22ae0ba3d042d302c2c6f22555c0758']['description'] = 'Votre colis est en cour de livraison dans le bureau de poste du destinataire.';
$status['c22ae0ba3d042d302c2c6f22555c0758']['notification_client'] = 0;
$status['c22ae0ba3d042d302c2c6f22555c0758']['notification_email_template'] = 0;
$status['c22ae0ba3d042d302c2c6f22555c0758']['remboursable'] = 'true';
$status['c22ae0ba3d042d302c2c6f22555c0758']['initial_transit'] = 'true';


//04 octobre 2012
$status['2023a2dad6d74b404b1c669579857d15']['description'] = 'Le destinataire du colis n\'habite pas à l\'adresse indiquée, le colis est retourné à l\'expéditeur';
$status['2023a2dad6d74b404b1c669579857d15']['notification_client'] = 0;
$status['2023a2dad6d74b404b1c669579857d15']['notification_email_template'] = 0;
$status['2023a2dad6d74b404b1c669579857d15']['remboursable'] = 'false';
$status['2023a2dad6d74b404b1c669579857d15']['initial_transit'] = 'false';


//06 décemebre 2012
$status['58b203e607c3ed15046fe3af0775a4dc']['description'] = 'Votre colis est arriv&eacute; par erreur sur un site. Il est en cours de r&eacute;acheminement vers son site de distribution.';
$status['58b203e607c3ed15046fe3af0775a4dc']['notification_client'] = 0;
$status['58b203e607c3ed15046fe3af0775a4dc']['notification_email_template'] = 0;
$status['58b203e607c3ed15046fe3af0775a4dc']['remboursable'] = 'true';
$status['58b203e607c3ed15046fe3af0775a4dc']['initial_transit'] = 'true';

$status['a61bb1a8edd9dbba3097c50e11a9b61b']['description'] = 'le colis n\'a pu être remis à son destinataire lors de notre passage et il en a été informé. Le colis sera adressé au bureau de poste du destinataire.';
$status['a61bb1a8edd9dbba3097c50e11a9b61b']['notification_client'] = 0;
$status['a61bb1a8edd9dbba3097c50e11a9b61b']['notification_email_template'] = 0;
$status['a61bb1a8edd9dbba3097c50e11a9b61b']['remboursable'] = 'true';
$status['a61bb1a8edd9dbba3097c50e11a9b61b']['initial_transit'] = 'true';


?>