<?php
/*
  $Id: database_tables.php,v 1.1 2003/03/14 02:10:58 hpdl Exp $

  osCommerce, Open Source E-Commerce Solutions
  http://www.oscommerce.com

  Copyright (c) 2003 osCommerce

  Released under the GNU General Public License
  Modified by Illan.P alias Ryu007
  Modified by Maxime (bug fix)
  Modified by Seb83 25/08/08 (reduc OK quand commande filleuil LIVREE)
  For Sponsorship
*/

  class ot_sponsorship {
    var $title, $output;

    function ot_sponsorship() {
      $this->code = 'ot_sponsorship';
      $this->header = MODULE_ORDER_TOTAL_SPONSORSHIP_HEADER;
      $this->title = MODULE_ORDER_TOTAL_SPONSORSHIP_TITLE;
      $this->description = MODULE_ORDER_TOTAL_SPONSORSHIP_DESCRIPTION;
      $this->enabled = MODULE_ORDER_TOTAL_SPONSORSHIP_STATUS;
      $this->sort_order = MODULE_ORDER_TOTAL_SPONSORSHIP_SORT_ORDER;
      $this->tax_class = MODULE_ORDER_TOTAL_SPONSORSHIP_TAX_CLASS;
      $this->output = array();
    }

    function process() {
      global $order, $currencies, $customer_id;
      
	  // Le filleul n'a jamais command on dsactive le module
      if (MODULE_ORDER_TOTAL_SPONSORSHIP_ORDER_BY_GODSON == 'true') {
        $godson_exists = tep_db_query("select customers_godson_id from " . TABLE_CUSTOMERS_SPONSORSHIP . " where activate = 'Y' and customers_sponsorship_id = '" . (int)$customer_id . "'");
		  
        // On fait une boucle pour vrifier chaque filleul
        $customer_no_order = array();
        while ( $godson = tep_db_fetch_array($godson_exists) ) {
	      $check_already_order = tep_db_query("select orders_id from " . TABLE_ORDERS . " where customers_id = '" . (int)$godson['customers_godson_id'] . "' AND orders_status = '3'");
          if (tep_db_num_rows($check_already_order) == 0) {
            // Ce client n'a pas fait de commande
            $customer_no_order[] = $godson['customers_godson_id'];
          }
        }
      }
	  
	  if (MODULE_ORDER_TOTAL_SPONSORSHIP_ORDER_BY_GODSON == 'true' && count($customer_no_order) > 0) {
	    $check_sp_exists = tep_db_query("select count(*) as total from " . TABLE_CUSTOMERS_SPONSORSHIP . " where activate = 'Y' and customers_sponsorship_id = '" . (int)$customer_id . "' and customers_godson_id NOT IN (" . implode(",", $customer_no_order) . ")");
      } else {
	    $check_sp_exists = tep_db_query("select count(*) as total from " . TABLE_CUSTOMERS_SPONSORSHIP . " where activate = 'Y' and customers_sponsorship_id = '" . (int)$customer_id . "'");
	  }
	  
	  $check_sp = tep_db_fetch_array($check_sp_exists);
      $total = intval($check_sp['total']);
	  
	  // Aucun filleul, on dsactive le module
	  if ($total <= 0) {
	    if ($this->enabled == true) {
          $this->enabled = false;
        }
	  } else {
	    // On limite le nombre de rsultat si on ne veux pas cumuler les rductions
	    if (MODULE_ORDER_TOTAL_SPONSORSHIP_CUMULATE == 'true') {
          $title = $this->title . ' ' . sprintf(TEXT_ORDER_TOTAL_SPONSORSHIP, $total) . ' :';
          $limit = '';
        } else {
	      $title = $this->title . ' :';
		  $limit = ' limit 1';
        }
		
	    if (MODULE_ORDER_TOTAL_SPONSORSHIP_ORDER_BY_GODSON == 'true' && count($customer_no_order) > 0) {
		  $s_id_query = tep_db_query("select sponsorship_id from " . TABLE_CUSTOMERS_SPONSORSHIP . " where activate = 'Y' and customers_sponsorship_id = '" . (int)$customer_id . "' and customers_godson_id NOT IN ('" . implode("','", $customer_no_order) . "') " . $limit);
        } else {
	  	  $s_id_query = tep_db_query("select sponsorship_id from " . TABLE_CUSTOMERS_SPONSORSHIP . " where activate = 'Y' and customers_sponsorship_id = '" . (int)$customer_id . "'" . $limit);
        }
		
        $_SESSION['sponsorship'] = array();
        while ( $s_id = tep_db_fetch_array($s_id_query) ) {
	      array_push($_SESSION['sponsorship'], $s_id['sponsorship_id']);
        }
	  
	    $reduction = 0;
	    // Pourcentage
	   if (substr(MODULE_ORDER_TOTAL_SPONSORSHIP_REDUCTION, -1) == '%') {
		  	// Seb83 : On n'utilise qu'un seul bon
		  	$nbBon="1";
        $reduction += ((MODULE_ORDER_TOTAL_SPONSORSHIP_REDUCTION / 100) * ($order->info['total'] - $order->info['shipping_cost']));		  	
      $tva = (($order->info['total'] - $reduction) / 1.196);
$total = (($order->info['total'] - $reduction) - $tva);
reset($order->info['tax_groups']);
while (list($key, $value) = each($order->info['tax_groups'])){
$get_tax = tep_get_tax_rate_from_desc($key);
$order->info['tax_groups'][$key] = $total; // prend en compte non pas la TVA par dfaut mais $total
}
	    } else if (MODULE_ORDER_TOTAL_SPONSORSHIP_CUMULATE == 'true') {
  			// Seb83 : On cumule les rductions au mieux (arrondi infrieur du total + FP)
  			$nbBon = floor($order->info['total'] / MODULE_ORDER_TOTAL_SPONSORSHIP_REDUCTION);
  			if ($nbBon > $total) $nbBon = $total;
  			
  			$reduction = MODULE_ORDER_TOTAL_SPONSORSHIP_REDUCTION * $nbBon;
    			
    		} else {
      			// Seb83 : On n'utilise qu'un seul bon
      		  $nbBon="1";
      			$reduction += MODULE_ORDER_TOTAL_SPONSORSHIP_REDUCTION;
    
    		}
    		
    		$title = $this->title . ' ' . sprintf(TEXT_ORDER_TOTAL_SPONSORSHIP, $nbBon) . sprintf(TEXT_ORDER_MAX_SPONSORSHIP, $total);
    		// Seb83 : On stock en session pour le checkout_process
    		$_SESSION['nbSponsorship'] = $nbBon;
	  
  	    if ($order->info['total'] > $reduction) {
  	      $order->info['total'] = $order->info['total'] - $reduction;
  	    } else {
  		  // La rduction est plus grande que le total : Total ngatif, on le met  0
            $order->info['total'] = 0;
  	    }
  		  
          $this->output[] = array('title' => $title,
                                  'text' => ' -' . $currencies->format($reduction),
                                  'value' => $reduction);
	   }
    }
	
    function check() {
      if ( !isset($this->check) ) {
        $check_query = tep_db_query("select configuration_value from " . TABLE_CONFIGURATION . " where configuration_key = 'MODULE_ORDER_TOTAL_SPONSORSHIP_STATUS'");
        $this->check = tep_db_num_rows($check_query);
      }

      return $this->check;
    }

    function keys() {
      return array('MODULE_ORDER_TOTAL_SPONSORSHIP_STATUS', 
	               'MODULE_ORDER_TOTAL_SPONSORSHIP_SORT_ORDER',
				   'MODULE_ORDER_TOTAL_SPONSORSHIP_ORDER_BY_GODSON', 
				   'MODULE_ORDER_TOTAL_SPONSORSHIP_REDUCTION', 
				   'MODULE_ORDER_TOTAL_SPONSORSHIP_CUMULATE', 
				   'MODULE_ORDER_TOTAL_SPONSORSHIP_TAX_CLASS');
    }

    function install() {
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Affichage parrainage', 'MODULE_ORDER_TOTAL_SPONSORSHIP_STATUS', 'true', 'Voulez vous afficher les r&eacute;ductions sur la commande ?', '6', '1', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('Ordre de tri', 'MODULE_ORDER_TOTAL_SPONSORSHIP_SORT_ORDER', '5', 'Ordre de tri pour l\'affichage (Le plus petit nombre est montr&eacute; en premier).', '6', '2', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('V&eacute;rification commande par filleul', 'MODULE_ORDER_TOTAL_SPONSORSHIP_ORDER_BY_GODSON', 'false', 'Si le filleul n\'a command&eacute; aucun produit, le parrain ne b&eacute;n&eacute;ficie d\'aucune r&eacute;duction !', '6', '3', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
	  tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('R&eacute;duction par parrain', 'MODULE_ORDER_TOTAL_SPONSORSHIP_REDUCTION', '5.00', 'R&eacute;duction sur le prix total de la commande.', '6', '4', now())");
      tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, set_function, date_added) values ('Cumuler les r&eacute;ductions', 'MODULE_ORDER_TOTAL_SPONSORSHIP_CUMULATE', 'true', 'Cumuler le nombre de r&eacute;duction pour faire baisser le total de la commande. Ne fonctionne pas avec un pourcentage de r&eacute;duction !', '6', '5', 'tep_cfg_select_option(array(\'true\', \'false\'), ', now())");
	  tep_db_query("insert into " . TABLE_CONFIGURATION . " (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, use_function, set_function, date_added) values ('Employer classe', 'MODULE_ORDER_TOTAL_SPONSORSHIP_TAX_CLASS', '0', 'Employez la classe suivante d\'imp&ocirc;ts sur les commissions de commande.', '6', '6', 'tep_get_tax_class_title', 'tep_cfg_pull_down_tax_classes(', now())");
    }

    function remove() {
      tep_db_query("delete from " . TABLE_CONFIGURATION . " where configuration_key in ('" . implode("', '", $this->keys()) . "')");
    }
  }
?>
