<?php
/**
 * Generic Installer
 *
 * Database install script for contributions
 * Dependencies -  installer_class.php
 * 
 * @package Generic Installer
 * @link http://www.fwrmedia.co.uk
 * @copyright Copyright 2008, Robert Fisher, FWR Media 
 * @author Robert Fisher, FWR Media, http://www.fwrmedia.co.uk 
 * @translator in french : SambaMambo, http://oscom-fr.com 10.2.2010
 * @lastdev $Author:: Rob                                              $:  Author of last commit
 * @lastmod $Date:: 2009-11-29 21:55:09 +0000 (Sun, 29 Nov 2009)       $:  Date of last commit
 * @version $Rev:: 117                                                 $:  Revision of last commit
 * @Id $Id:: installer.php 117 2009-11-29 21:55:09Z Rob                $:  Full Details 
 * @filesource
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
// Initial set up
// set the level of error reporting
error_reporting( E_ALL & ~E_NOTICE & ~E_DEPRECATED );
date_default_timezone_set("EUROPE/LONDON");
session_start();
require_once( 'includes/configure.php' );
require_once( 'includes/database_tables.php' );
define( 'FWR_INSTALLER', 1 );
require_once( 'installer_class.php' );
$installer = new installer_class;
$installer->showHeader();
$error = '';
$required_version = '5.1.4';
if ( PHP_VERSION < $required_version ) {
  $error .= '<div class="error">Vous ne pouvez pas installer ce script car votre PHP version ("' . PHP_VERSION . '") est trop basse. La version ncessaire est ' . $required_version . '+</div>' . PHP_EOL;
}
if ( false === function_exists( 'filter_var' ) ) {
  $error .= '<div class="error">Vous ne pouvez pas installer ce script car la fonction filter_var() n\'existe pas</div>' . PHP_EOL;
}
if ( false === function_exists( 'gzinflate' ) ) {
  $error .= '<div class="error">Vous ne pouvez pas installer ce script car la fonction gzinflate()/gzdeflate() n\'existe pas</div>' . PHP_EOL;
}
if ( false === class_exists( 'SplFileInfo' ) ) {
  $error .= '<div class="error">Vous ne pouvez pas installer ce script car la SPL (standard PHP Library) n\'existe pas</div>' . PHP_EOL;
}
if ( false === class_exists( 'DirectoryIterator' ) ) {
  $error .= '<div class="error">Vous ne pouvez pas installer ce script car la class DirectoryIterator n\'existe pas</div>' . PHP_EOL;
}
if ( !empty($error) ) {
  echo $error;
  $installer->showFooter();
  exit;
}
/**
* Build your install using the arrays below
* 
* @param $config_inserts - configuration group install
* plus configuration being an array of related configuration install values
* @param $tables_to_add - array of tables to be created
* @param $tables_to_alter - array tables we are going to alter
* @param $fields_to_add - array of fields we are going to add to specific tables
* @param $fields_to_alter - array of fields we are going to alter
*/

################## START USER DEFINED INSTALL ARRAYS #####################

$config_inserts = array('group' => array(
                                     array( 'configuration_group_title'       => 'Seo Urls 5',
                                            'configuration_group_description' => 'Options pour ULTIMATE Seo Urls 5 par FWR Media',
                                            'sort_order'                      => '99',
                                            'visible'                         => '1',
                                            'configuration' => array(
                                                                 array( 'configuration_title'       => 'Activer SEO URLs 5?',
                                                                        'configuration_key'         => 'SEO_URLS_ENABLED',
                                                                        'configuration_value'       => 'true',
                                                                        'configuration_description' => 'Activer SEO URLs 5',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => NULL,
                                                                        'set_function'              => "tep_cfg_select_option(array(''true'', ''false''), " ),
                                                                 array( 'configuration_title'       => 'Ajouter le cPath aux produits?',
                                                                        'configuration_key'         => 'SEO_URLS_ADD_CPATH_TO_PRODUCT_URLS',
                                                                        'configuration_value'       => 'false',
                                                                        'configuration_description' => 'Cela rajoutera le cPath  la fin (i.e. - some-product-p-1.html?cPath=xx).',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => NULL,
                                                                        'set_function'              => "tep_cfg_select_option(array(''true'', ''false''), " ),
                                                                 array( 'configuration_title'       => 'Ajouter la catgorie ?',
                                                                        'configuration_key'         => 'SEO_URLS_ADD_CAT_PARENT',
                                                                        'configuration_value'       => 'true',
                                                                        'configuration_description' => 'Cela ajoutera la catgorie  (i.e. - parent-category-c-1.html).',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => NULL,
                                                                        'set_function'              => "tep_cfg_select_option(array(''true'', ''false''), " ),     
                                                                 array( 'configuration_title'       => 'Filtrer les petits mots',
                                                                        'configuration_key'         => 'SEO_URLS_FILTER_SHORT_WORDS',
                                                                        'configuration_value'       => '1',
                                                                        'configuration_description' => '<b>Filtrer les petits mots.</b><br>1 = enlve les mot d une lettre<br>2 = enlve les mot de 2 lettres ou moins<br>3 = enlve les mot de 3 lettres ou moins<br>',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => NULL,
                                                                        'set_function'              => "tep_cfg_select_option(array(''1'', ''2'', ''3''), " ),
                                                                 array( 'configuration_title'       => 'Faire des URLs valide W3C?',
                                                                        'configuration_key'         => 'SEO_URLS_USE_W3C_VALID',
                                                                        'configuration_value'       => 'true',
                                                                        'configuration_description' => 'Faire des URLs valide W3C.',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => NULL,
                                                                        'set_function'              => "tep_cfg_select_option(array(''true'', ''false''), " ),
                                                                 array( 'configuration_title'       => 'Choisir le type de Rcriture',
                                                                        'configuration_key'         => 'SEO_URLS_TYPE',
                                                                        'configuration_value'       => 'standard',
                                                                        'configuration_description' => 'Choisir le format:<br><b>rewrite</b><br>mysite.com/great-product-p-3.html<br><b>standard</b><br>mysite.com/product_info.php/great-product-p-3',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => NULL,
                                                                        'set_function'              => "tep_cfg_select_option(array(''rewrite'', ''standard''), " ),
                                                                 array( 'configuration_title'       => 'Entrer les caractres spciaux  convertir.',
                                                                        'configuration_key'         => 'SEO_URLS_CHAR_CONVERT_SET',
                                                                        'configuration_value'       => '',
                                                                        'configuration_description' => 'format: <b>char=>conv,char2=>conv2</b> exemple : =>e,=>e,=>c',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => NULL,
                                                                        'set_function'              => NULL ),
                                                                 array( 'configuration_title'       => 'Enlever les caractres non-alphanumrique (autres que des chiffres et des lettres)?',
                                                                        'configuration_key'         => 'SEO_URLS_REMOVE_ALL_SPEC_CHARS',
                                                                        'configuration_value'       => 'true',
                                                                        'configuration_description' => 'Enlever les caractres non-alphanumrique.',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => NULL,
                                                                        'set_function'              => "tep_cfg_select_option(array(''true'', ''false''), " ),
                                                                 array( 'configuration_title'       => 'Nombre de jours pour garder le cache.',
                                                                        'configuration_key'         => 'SEO_URLS_CACHE_DAYS',
                                                                        'configuration_value'       => '7',
                                                                        'configuration_description' => 'Arps le nombre paramtr, le cache sera vid automatiquement .',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => NULL,
                                                                        'set_function'              => NULL ),
                                                                 array( 'configuration_title'       => 'Vider le cache SEO URLs',
                                                                        'configuration_key'         => 'SEO_URLS_CACHE_RESET',
                                                                        'configuration_value'       => 'false',
                                                                        'configuration_description' => 'Vider le cache SEO',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => 'tep_reset_cache_data_seo_urls',
                                                                        'set_function'              => "tep_cfg_select_option(array(''reset'', ''false''), " ),
                                                                 array( 'configuration_title'       => 'Debug mode true/false.',
                                                                        'configuration_key'         => 'SEO_URLS_OUPUT_PERFORMANCE',
                                                                        'configuration_value'       => 'false',
                                                                        'configuration_description' => '<span style="color: red;">ne mettez <b>PAS</b> le mode debug sur true sur une boutique en ligne</span>',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => NULL,
                                                                        'set_function'              => "tep_cfg_select_option(array(''true'', ''false''), " ),
                                                                 array( 'configuration_title'       => 'systme de cache.',
                                                                        'configuration_key'         => 'SEO_URLS_CACHE_SYSTEM',
                                                                        'configuration_value'       => 'FileSystem',
                                                                        'configuration_description' => '<b>Filesystem:</b><br>pas de requette une fois le cache lu.<br><b>Database:</b><br>Requette aprs la lecture du cache<br><b>Memcached:</b><br>Ncessite memcached dans apache et php.ini.',
                                                                        'configuration_group_id'    => '',
                                                                        'sort_order'                => '99',
                                                                        'last_modified'             => date( "Y-m-d H:i:s" ),
                                                                        'date_added'                => date( "Y-m-d H:i:s" ),
                                                                        'use_function'              => NULL,
                                                                        'set_function'              => "tep_cfg_select_option(array(''FileSystem'', ''Database'', ''Memcached''), " )
                                                                        )
                                            )
                                     ));

$tables_to_add = array( 'usu_cache' => "CREATE TABLE `usu_cache` (
                                        `cache_name` varchar(32) NOT NULL,
                                        `cache_data` mediumtext NOT NULL,
                                        `cache_date` datetime NOT NULL,
                                        PRIMARY KEY  (`cache_name`)
                                        ) ENGINE=MyISAM;" );
                                                 
$tables_to_alter = array();
                      
$fields_to_add = array();
                        
$fields_to_alter = array();

################### END USER DEFINED INSTALL ARRAYS ######################

/**
* Stage 1 - Check all database alterations for current existence
*/
$errors = false;
if( $installer->stage == '1' ) {
echo '    <div id="messages_container">' . "\n";
echo '      <ul>' . "\n";
// Check config inserts
if( !empty($config_inserts) ){
  if( $installer->configExists( $config_inserts ) ) {
    echo '        <li class="error">Au moins une donne existe dj!</li>' . "\n";
    $errors = true;
  } else {
    echo '        <li class="success">Tout semble marcher.</li>' . "\n";
    if( false !== $installer->autoIncrement ) {
    echo '        <li class="success">Configuration Group auto increment commencant par ' . $installer->autoIncrement . '</li>' . "\n";
    }
  }
} else {
    echo '        <li class="dormant">Pas de donnes  ajouter.</li>' . "\n";
}
// Check tables to add
if( !empty( $tables_to_add ) ) {                       
  if( $installer->tablesExist( $tables_to_add ) ) {
    echo '        <li class="error">Au moins une table existe dj!</li>' . "\n";
    $errors = true;
  } else {
    echo '        <li class="success">Tables sont prtes  tre ajoutes.</li>' . "\n";
  }
} else {
    echo '        <li class="dormant">Pas de table  ajouter.</li>' . "\n";
}
// Check tables to add
if( !empty( $tables_to_alter ) ) {                       
  if( !$installer->tablesExist( $tables_to_alter ) ) {
    echo '        <li class="error">Pas de Tables  modifier!</li>' . "\n";
    $errors = true;
  } else {
    echo '        <li class="success">Tables  modifier sont prtes  tre ajoutes.</li>' . "\n";
  }
} else {
    echo '        <li class="dormant">Pas de Tables  modifier.</li>' . "\n";
}
// Check fields to add
if( !empty( $fields_to_add ) ) {
  if( $installer->fields_exist( $fields_to_add ) ) {
    echo '        <li class="error">Au moins un champ existe dj!</li>' . "\n";
    $errors = true;
  } else {
    echo '        <li class="success">Les champs sont prts  tre ajouts.</li>' . "\n";
  }
} else {
    echo '        <li class="dormant">Pas de champs  insrer.</li>' . "\n";
}
// Check fields to alter
if( !empty( $fields_to_alter ) ) {
  if( !$installer->fields_exist( $fields_to_alter ) ) {
    echo '        <li class="error">Il n y a pas de champs  modifier!</li>' . "\n";
     $errors = true;
  } else {
    echo '        <li class="success">Les champs sont prts  tre ajouts.</li>' . "\n";
  }
} else {
    echo '        <li class="dormant">Pas de champs  modifier.</li>' . "\n";
}
echo '      </ul>' . "\n";
echo '    </div>' . "\n";
$installer->showStatus( $errors );

} elseif( $installer->stage == '2' ) {  // Stage 2 - Install
  
  $installer->implementInstall( $config_inserts, $tables_to_add, $tables_to_alter, $fields_to_add, $fields_to_alter );
  if( empty( $installer->install['error'] ) ) {
    $installer->outputInstallSuccess();
    $installer_class = str_replace( 'installer.php', '', __FILE__ ) . 'installer_class.php';
    @unlink( $installer_class );
    @unlink( __FILE__ );
    echo '<div style="padding: 0.5em; margin-top: 3em;">' . ( ( !file_exists( __FILE__ ) && !file_exists( $installer_class ) ) ? '<b style="color: green;">Fichier  ffacer!<b>' : '<b style="color: red;">installer.php and installer_class.php !<b>' ) . '</div>' . PHP_EOL;
  } else {
    $installer->outputErrors();
  }
  
}

if( false === $errors ) {
  $_SESSION['stage'] = 1;
  $_SESSION['token'] = $installer->token;
  if( $installer->stage == '1' ) {
    $installer->drawPostForm( 'Install Database Settings' );
  }
}
$installer->showFooter();
$installer->db->close(); 
?>